/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.util.SnapshotReport;
import org.rhq.core.util.stream.StreamUtil;

public class AgentSnapshotReport
extends SnapshotReport {
    private static final Log log = LogFactory.getLog(AgentSnapshotReport.class);
    private final String agentInstallDir;
    private final Properties agentConfiguration;

    public AgentSnapshotReport(String name, String description, Configuration agentPluginConfiguration, String agentInstallDir, Properties agentConfiguration, String tmpDirectory) {
        super(name, description, AgentSnapshotReport.buildConfiguration(agentPluginConfiguration, agentInstallDir, tmpDirectory));
        this.agentInstallDir = agentInstallDir;
        this.agentConfiguration = agentConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate() throws Exception {
        File liveConfigFile = this.writeLiveConfigurationFile();
        try {
            File file = super.generate();
            return file;
        }
        finally {
            if (liveConfigFile != null) {
                liveConfigFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeLiveConfigurationFile() {
        try {
            File configDir = new File(this.agentInstallDir, "conf");
            File liveConfigFile = new File(configDir, "live-agent-configuration.properties");
            BufferedOutputStream fos = null;
            try {
                fos = new BufferedOutputStream(new FileOutputStream(liveConfigFile));
                this.agentConfiguration.store(fos, null);
            }
            catch (Throwable throwable) {
                StreamUtil.safeClose(fos);
                throw throwable;
            }
            StreamUtil.safeClose((Closeable)fos);
            return liveConfigFile;
        }
        catch (Exception e) {
            log.warn((Object)("Cannot store live agent config - will not snapshot it. Cause: " + e));
            return null;
        }
    }

    private static Configuration buildConfiguration(Configuration pluginConfiguration, String installDir, String tmpDir) {
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("snapshotReportOutputDirectory", (Object)tmpDir));
        config.put((Property)new PropertySimple("snapshotBaseDirectory", (Object)installDir));
        config.put((Property)new PropertySimple("snapshotConfigEnabled", (Object)pluginConfiguration.getSimpleValue("snapshotConfigEnabled", null)));
        config.put((Property)new PropertySimple("snapshotLogEnabled", (Object)pluginConfiguration.getSimpleValue("snapshotLogEnabled", null)));
        config.put((Property)new PropertySimple("snapshotDataEnabled", (Object)pluginConfiguration.getSimpleValue("snapshotDataEnabled", null)));
        config.put((Property)new PropertySimple("snapshotConfigDirectory", (Object)"conf"));
        config.put((Property)new PropertySimple("snapshotLogDirectory", (Object)"logs"));
        config.put((Property)new PropertySimple("snapshotDataDirectory", (Object)"data"));
        config.put((Property)new PropertySimple("snapshotDataRegex", (Object)".*\\.dat"));
        return config;
    }
}

