/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.InvalidBuildFileException;
import org.rhq.bundle.ant.LoggerAntBuildListener;
import org.rhq.bundle.ant.task.BundleTask;
import org.rhq.bundle.ant.task.DeployTask;
import org.rhq.bundle.ant.task.InputPropertyTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntLauncher {
    public static final String DEPLOY_DIR_PROP = "rhq.deploy.dir";
    public static final String DEPLOY_ID_PROP = "rhq.deploy.id";
    private static final String ANTCONTRIB_ANT_TASKS = "net/sf/antcontrib/antcontrib.properties";
    private final Log log = LogFactory.getLog(AntLauncher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleAntProject startAnt(File buildFile, String targetName, Set<String> customTaskDefs, Properties properties, File logFile, boolean logStdOut, boolean execute) {
        PrintWriter logFileOutput = null;
        try {
            logFileOutput = new PrintWriter(new FileOutputStream(logFile, true));
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (customTaskDefs == null) {
                customTaskDefs = new HashSet<String>(1);
            }
            customTaskDefs.add(ANTCONTRIB_ANT_TASKS);
            Properties taskDefs = new Properties();
            for (String customTaskDef : customTaskDefs) {
                InputStream taskDefsStream = classLoader.getResourceAsStream(customTaskDef);
                try {
                    taskDefs.load(taskDefsStream);
                }
                finally {
                    taskDefsStream.close();
                }
            }
            BundleAntProject project = new BundleAntProject();
            project.setCoreLoader(classLoader);
            project.init();
            project.setBaseDir(buildFile.getParentFile());
            if (properties != null) {
                for (Map.Entry<Object, Object> property : properties.entrySet()) {
                    project.setProperty(property.getKey().toString(), property.getValue().toString().replace("\\", "\\\\"));
                }
            }
            project.addBuildListener(new LoggerAntBuildListener(targetName, logFileOutput, 4));
            if (logStdOut) {
                PrintWriter stdout = new PrintWriter(System.out);
                project.addBuildListener(new LoggerAntBuildListener(targetName, stdout, 2));
            }
            for (Map.Entry<Object, Object> taskDef : taskDefs.entrySet()) {
                project.addTaskDefinition(taskDef.getKey().toString(), Class.forName(taskDef.getValue().toString(), true, classLoader));
            }
            class AllOrNothingTarget
            extends Target {
                public boolean doNothing = true;

                AllOrNothingTarget() {
                }

                public void execute() throws BuildException {
                    if (!this.doNothing) {
                        super.execute();
                    }
                }
            }
            AllOrNothingTarget allOrNothingTarget = new AllOrNothingTarget();
            allOrNothingTarget.setName("");
            allOrNothingTarget.setProject(project);
            AntXMLContext context = new AntXMLContext((Project)project);
            context.setImplicitTarget((Target)allOrNothingTarget);
            context.getTargets().clear();
            context.getTargets().addElement(context.getImplicitTarget());
            String REFID_CONTEXT = "ant.parsing.context";
            project.addReference(REFID_CONTEXT, context);
            project.addReference("ant.targets", context.getTargets());
            ProjectHelper2 helper = new ProjectHelper2();
            try {
                helper.parse((Project)project, (Object)buildFile);
            }
            catch (BuildException e) {
                throw new InvalidBuildFileException("Failed to parse bundle Ant build file.", e);
            }
            this.validateAndPreprocess(project);
            this.log.debug((Object)"==================== PARSED BUNDLE ANT BUILD FILE ====================");
            this.log.debug((Object)(" Bundle Name: " + project.getBundleName()));
            this.log.debug((Object)(" Bundle Version: " + project.getBundleVersion()));
            this.log.debug((Object)(" Bundle Description: " + project.getBundleDescription()));
            this.log.debug((Object)(" Deployment Configuration: " + project.getConfiguration().toString(true)));
            this.log.debug((Object)"======================================================================");
            if (execute) {
                int deploymentId;
                allOrNothingTarget.doNothing = false;
                helper.parse((Project)project, (Object)buildFile);
                String deployDir = properties.getProperty(DEPLOY_DIR_PROP);
                if (deployDir == null) {
                    throw new BuildException("Required property [rhq.deploy.dir] was not specified.");
                }
                File deployDirFile = new File(deployDir);
                if (!deployDirFile.isAbsolute()) {
                    throw new BuildException("Value of property [rhq.deploy.dir] (" + deployDirFile + ") is not an absolute path.");
                }
                project.setDeployDir(deployDirFile);
                String deploymentIdStr = properties.getProperty(DEPLOY_ID_PROP);
                if (deploymentIdStr == null) {
                    throw new BuildException("Required property [rhq.deploy.id] was not specified.");
                }
                try {
                    deploymentId = Integer.parseInt(deploymentIdStr);
                }
                catch (Exception e) {
                    throw new BuildException("Value of property [rhq.deploy.id] (" + deploymentIdStr + ") is not valid.", (Throwable)e);
                }
                project.setDeploymentId(deploymentId);
                project.executeTarget(targetName == null ? project.getDefaultTarget() : targetName);
            }
            BundleAntProject bundleAntProject = project;
            return bundleAntProject;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot run Ant on build file [" + buildFile + "]. Cause: " + e, e);
        }
        finally {
            if (logFileOutput != null) {
                logFileOutput.close();
            }
        }
    }

    private void validateAndPreprocess(BundleAntProject project) throws InvalidBuildFileException {
        AntXMLContext antParsingContext = (AntXMLContext)project.getReference("ant.parsing.context");
        Vector targets = antParsingContext.getTargets();
        int bundleTaskCount = 0;
        Task unconfiguredBundleTask = null;
        for (Object targetObj : targets) {
            Task[] tasks;
            Target target = (Target)targetObj;
            for (Task task : tasks = target.getTasks()) {
                if (task.getTaskName().equals("rhq:bundle")) {
                    this.abortIfTaskWithinTarget(target, task);
                    ++bundleTaskCount;
                    unconfiguredBundleTask = task;
                    continue;
                }
                if (task.getTaskName().equals("rhq:inputProperty")) {
                    this.abortIfTaskWithinTarget(target, task);
                    InputPropertyTask inputPropertyTask = (InputPropertyTask)AntLauncher.preconfigureTask(task);
                    continue;
                }
                if (!task.getTaskName().equals("rhq:deploy")) continue;
                DeployTask deployTask = (DeployTask)AntLauncher.preconfigureTask(task);
                Map<File, File> files = deployTask.getFiles();
                for (File file : files.values()) {
                    project.getBundleFileNames().add(file.getName());
                }
                Set<File> archives = deployTask.getArchives();
                for (File archive : archives) {
                    project.getBundleFileNames().add(archive.getName());
                }
            }
        }
        if (bundleTaskCount == 0) {
            throw new InvalidBuildFileException("rhq:bundle task not found - an RHQ bundle Ant build file must contain exactly one rhq:bundle task.");
        }
        if (bundleTaskCount > 1) {
            throw new InvalidBuildFileException("More than one rhq:bundle task found - an RHQ bundle Ant build file must contain exactly one rhq:bundle task.");
        }
        BundleTask bundleTask = (BundleTask)AntLauncher.preconfigureTask(unconfiguredBundleTask);
    }

    private void abortIfTaskWithinTarget(Target target, Task task) throws InvalidBuildFileException {
        if (!target.getName().equals("")) {
            throw new InvalidBuildFileException(task.getTaskName() + " task found within [" + target.getName() + "] target - it must be outside of any targets (at the top of the build file).");
        }
    }

    private static Task preconfigureTask(Task task) {
        if (task instanceof UnknownElement) {
            task.maybeConfigure();
            Task resolvedTask = ((UnknownElement)task).getTask();
            return resolvedTask != null ? resolvedTask : task;
        }
        return task;
    }
}

