/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.task;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.rhq.bundle.ant.task.AbstractBundleTask;
import org.rhq.bundle.ant.type.ArchiveType;
import org.rhq.bundle.ant.type.FileSet;
import org.rhq.bundle.ant.type.FileType;
import org.rhq.bundle.ant.type.IgnoreType;
import org.rhq.bundle.ant.type.ReplaceType;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.updater.Deployer;
import org.rhq.core.util.updater.DeploymentProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployTask
extends AbstractBundleTask {
    private Map<File, File> files = new LinkedHashMap<File, File>();
    private Set<File> archives = new LinkedHashSet<File>();
    private Pattern ignorePattern;
    private Pattern replacePattern;
    private boolean preview;

    public void maybeConfigure() throws BuildException {
        super.maybeConfigure();
    }

    public void execute() throws BuildException {
        int deploymentId = this.getDeploymentId();
        DeploymentProperties deploymentProps = new DeploymentProperties(deploymentId, this.getProject().getBundleName(), this.getProject().getBundleVersion(), this.getProject().getBundleDescription());
        File deployDir = this.getProject().getDeployDir();
        TemplateEngine templateEngine = this.createTemplateEngine();
        this.log("Deploying files " + this.files + "...");
        this.log("Deploying archives " + this.archives + "...");
        Deployer deployer = new Deployer(deploymentProps, this.archives, this.files, deployDir, this.replacePattern, templateEngine, this.ignorePattern);
        try {
            deployer.deploy();
        }
        catch (Exception e) {
            throw new BuildException("Failed to deploy bundle '" + this.getProject().getBundleName() + "' version " + this.getProject().getBundleVersion() + ".", (Throwable)e);
        }
    }

    public Map<File, File> getFiles() {
        return this.files;
    }

    public Set<File> getArchives() {
        return this.archives;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void addConfigured(FileType file) {
        File destFile = file.getDestinationFile();
        if (destFile == null) {
            File destDir = file.getDestinationDir();
            destFile = new File(destDir, file.getSource().getName());
        }
        this.files.put(file.getSource(), destFile);
    }

    public void addConfigured(ArchiveType archive) {
        this.archives.add(archive.getSource());
    }

    public void addConfigured(IgnoreType ignore) {
        List<FileSet> fileSets = ignore.getFileSets();
        this.ignorePattern = DeployTask.getPattern(fileSets);
    }

    public void addConfigured(ReplaceType replace) {
        List<FileSet> fileSets = replace.getFileSets();
        this.replacePattern = DeployTask.getPattern(fileSets);
    }

    private int getDeploymentId() {
        String deploymentIdStr = this.getProject().getProperty("rhq.deploy.id");
        if (deploymentIdStr == null) {
            return 0;
        }
        return Integer.parseInt(deploymentIdStr);
    }

    private TemplateEngine createTemplateEngine() {
        TemplateEngine templateEngine = SystemInfoFactory.fetchTemplateEngine();
        Configuration config = this.getProject().getConfiguration();
        for (PropertySimple prop : config.getSimpleProperties().values()) {
            templateEngine.getTokens().put(prop.getName(), prop.getStringValue());
        }
        return templateEngine;
    }

    private static Pattern getPattern(List<FileSet> fileSets) {
        boolean first = true;
        StringBuilder regex = new StringBuilder();
        for (FileSet fileSet : fileSets) {
            if (!first) {
                regex.append("|");
            } else {
                first = false;
            }
            regex.append("(");
            File dir = fileSet.getDir();
            if (dir != null) {
                regex.append(dir);
                regex.append('/');
            }
            if (fileSet.getIncludePatterns().length == 0) {
                regex.append(".*");
            } else {
                boolean firstIncludePattern = true;
                for (String includePattern : fileSet.getIncludePatterns()) {
                    if (!firstIncludePattern) {
                        regex.append("|");
                    } else {
                        firstIncludePattern = false;
                    }
                    regex.append("(");
                    for (int i = 0; i < includePattern.length(); ++i) {
                        char c = includePattern.charAt(i);
                        if (c == '?') {
                            regex.append('.');
                            continue;
                        }
                        if (c == '*') {
                            char c2;
                            if (i + 1 < includePattern.length() && (c2 = includePattern.charAt(++i)) == '*') {
                                regex.append(".*");
                                ++i;
                                continue;
                            }
                            regex.append("[^/]*");
                            continue;
                        }
                        regex.append(c);
                    }
                    regex.append(")");
                }
            }
            regex.append(")");
        }
        return Pattern.compile(regex.toString());
    }
}

