/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.task;

import org.apache.tools.ant.BuildException;
import org.rhq.bundle.ant.task.AbstractBundleTask;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;

public class InputPropertyTask
extends AbstractBundleTask {
    private String name;
    private String description;
    private boolean required = true;
    private String defaultValue;
    private String type = PropertySimpleType.STRING.xmlName();

    public void maybeConfigure() throws BuildException {
        super.maybeConfigure();
        this.validateAttributes();
        ConfigurationDefinition configDef = this.getProject().getConfigurationDefinition();
        PropertySimpleType propSimpleType = PropertySimpleType.fromXmlName((String)this.type);
        PropertyDefinitionSimple propDef = new PropertyDefinitionSimple(this.name, this.description, this.required, propSimpleType);
        configDef.put((PropertyDefinition)propDef);
    }

    public void execute() throws BuildException {
        String value = this.getProject().getProperty(this.name);
        if (value == null) {
            value = this.defaultValue;
        }
        if (value == null && this.required) {
            throw new BuildException("No value was specified for required input property '" + this.name + "', and no default is defined for the property.");
        }
        String valueString = value != null ? "'" + value + "'" : "<null>";
        this.log("Initializing input property '" + this.name + "' with value " + valueString + "...");
        PropertySimple prop = new PropertySimple(this.name, (Object)value);
        ConfigurationDefinition configDef = this.getProject().getConfigurationDefinition();
        Configuration config = this.getProject().getConfiguration();
        config.put((Property)prop);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected void validateAttributes() throws BuildException {
        if (this.name == null) {
            throw new BuildException("The 'name' attribute is required.");
        }
        if (this.name.length() == 0) {
            throw new BuildException("The 'name' attribute must have a non-empty value.");
        }
        try {
            PropertySimpleType.fromXmlName((String)this.type);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Illegal value for 'type' attribute: " + this.type);
        }
        if (this.defaultValue == null && !this.required) {
            this.log("No default value was specified for optional input property '" + this.name + "'.", 1);
        }
    }
}

