/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant;

import java.io.PrintWriter;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class LoggerAntBuildListener
implements BuildListener {
    private final String mainTarget;
    private final PrintWriter output;
    private final int priorityThreshold;

    public LoggerAntBuildListener(String target, PrintWriter printWriter, int priorityThreshold) {
        this.mainTarget = target != null ? target : "(default)";
        this.output = printWriter;
        this.priorityThreshold = priorityThreshold;
        this.output.println("======================================");
        this.output.println("Ant target [" + this.mainTarget + "]");
        this.output.println(new Date());
        this.output.println("======================================");
    }

    public void buildFinished(BuildEvent event) {
        this.logEvent(event, "FINISHED! [" + this.mainTarget + ']');
    }

    public void buildStarted(BuildEvent event) {
        this.logEvent(event, "STARTED! [" + this.mainTarget + ']');
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() <= this.priorityThreshold) {
            this.logEvent(event, null);
        }
    }

    public void targetFinished(BuildEvent event) {
        this.logEvent(event, null);
    }

    public void targetStarted(BuildEvent event) {
        this.logEvent(event, null);
    }

    public void taskFinished(BuildEvent event) {
        this.logEvent(event, null);
    }

    public void taskStarted(BuildEvent event) {
        this.logEvent(event, null);
    }

    private void logEvent(BuildEvent event, String additionalMessage) {
        String message = event.getMessage();
        Throwable exception = event.getException();
        Target target = event.getTarget();
        Task task = event.getTask();
        if (additionalMessage != null) {
            this.output.println(additionalMessage);
        }
        if (target != null) {
            this.output.print("[" + target.getName() + "] ");
        }
        if (task != null) {
            this.output.print("<" + task.getTaskName() + "> ");
        }
        if (message != null) {
            this.output.print(message);
        }
        if (exception != null) {
            this.output.println();
            exception.printStackTrace(this.output);
        }
        this.output.println();
        this.output.flush();
    }
}

