/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ProxySetup;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.DeploymentPhase;
import org.rhq.core.util.updater.DeploymentsMetadata;

public class AntMain
implements org.apache.tools.ant.launch.AntMain {
    private static final Set LAUNCH_COMMANDS = new HashSet();
    private static final String BUILD_FILE_NAME = "deploy.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out;
    private static PrintStream err;
    private Vector targets = new Vector();
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(1);
    private Vector propertyFiles = new Vector(1);
    private boolean allowInput = true;
    private boolean keepGoingMode = false;
    private String loggerClassname = null;
    private String inputHandlerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static boolean isLogFileUsed;
    private Integer threadPriority = null;
    private boolean proxy = false;
    private static String antVersion;

    private static void printMessage(Throwable t) {
        String message = t.getMessage();
        if (message != null) {
            System.err.println(message);
        }
    }

    public static void start(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        Main m = new Main();
        m.startAnt(args, additionalUserProperties, coreLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnt(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        try {
            Diagnostics.validateVersion();
            this.processArgs(args);
        }
        catch (Throwable exc) {
            AntMain.handleLogfile();
            AntMain.printMessage(exc);
            this.exit(1);
            return;
        }
        if (additionalUserProperties != null) {
            Enumeration<Object> e = additionalUserProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String property = additionalUserProperties.getProperty(key);
                this.definedProps.put(key, property);
            }
        }
        int exitCode = 1;
        try {
            try {
                this.runBuild(coreLoader);
                exitCode = 0;
            }
            catch (ExitStatusException ese) {
                exitCode = ese.getStatus();
                if (exitCode != 0) {
                    throw ese;
                }
            }
        }
        catch (BuildException be) {
            if (err != System.err) {
                AntMain.printMessage(be);
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            AntMain.printMessage(exc);
        }
        finally {
            AntMain.handleLogfile();
        }
        this.exit(exitCode);
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    private static void handleLogfile() {
        if (isLogFileUsed) {
            FileUtils.close((OutputStream)out);
            FileUtils.close((OutputStream)err);
        }
    }

    public static void main(String[] args) {
        AntMain.start(args, null, null);
    }

    public AntMain() {
    }

    protected AntMain(String[] args) throws BuildException {
        this.processArgs(args);
    }

    private void processArgs(String[] args) {
        Object searchForThis = null;
        boolean searchForFile = false;
        PrintStream logTo = null;
        boolean justPrintUsage = false;
        boolean justPrintVersion = false;
        boolean justPrintDiagnostics = false;
        for (int i = 0; i < args.length; ++i) {
            String msg;
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("-h")) {
                justPrintUsage = true;
                continue;
            }
            if (arg.equals("-version")) {
                justPrintVersion = true;
                continue;
            }
            if (arg.equals("-diagnostics")) {
                justPrintDiagnostics = true;
                continue;
            }
            if (arg.equals("-quiet") || arg.equals("-q")) {
                this.msgOutputLevel = 1;
                continue;
            }
            if (arg.equals("-verbose") || arg.equals("-v")) {
                this.msgOutputLevel = 3;
                continue;
            }
            if (arg.equals("-debug") || arg.equals("-d")) {
                this.msgOutputLevel = 4;
                continue;
            }
            if (arg.equals("-noinput")) {
                this.allowInput = false;
                continue;
            }
            if (arg.equals("-logfile") || arg.equals("-l")) {
                try {
                    File logFile = new File(args[i + 1]);
                    ++i;
                    logTo = new PrintStream(new FileOutputStream(logFile));
                    isLogFileUsed = true;
                    continue;
                }
                catch (IOException ioe) {
                    String msg2 = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    throw new BuildException(msg2);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    String msg3 = "You must specify a log file when using the -log argument";
                    throw new BuildException(msg3);
                }
            }
            if (arg.equals("-listener")) {
                i = this.handleArgListener(args, i);
                continue;
            }
            if (arg.startsWith("-D")) {
                i = this.handleArgDefine(args, i);
                continue;
            }
            if (arg.equals("-logger")) {
                i = this.handleArgLogger(args, i);
                continue;
            }
            if (arg.equals("-inputhandler")) {
                i = this.handleArgInputHandler(args, i);
                continue;
            }
            if (arg.equals("-emacs") || arg.equals("-e")) {
                this.emacsMode = true;
                continue;
            }
            if (arg.equals("-projecthelp") || arg.equals("-p")) {
                this.projectHelp = true;
                continue;
            }
            if (arg.startsWith("-propertyfile")) {
                i = this.handleArgPropertyFile(args, i);
                continue;
            }
            if (arg.equals("-k") || arg.equals("-keep-going")) {
                this.keepGoingMode = true;
                continue;
            }
            if (arg.equals("-nice")) {
                i = this.handleArgNice(args, i);
                continue;
            }
            if (LAUNCH_COMMANDS.contains(arg)) {
                msg = "Ant's Main method is being handed an option " + arg + " that is only for the launcher class." + "\nThis can be caused by a version mismatch between " + "the ant script/.bat file and Ant itself.";
                throw new BuildException(msg);
            }
            if (arg.equals("-autoproxy")) {
                this.proxy = true;
                continue;
            }
            if (arg.startsWith("-")) {
                msg = "Unknown argument: " + arg;
                System.err.println(msg);
                AntMain.printUsage();
                throw new BuildException("");
            }
            this.targets.addElement(arg);
        }
        if (this.msgOutputLevel >= 3 || justPrintVersion) {
            AntMain.printVersion(this.msgOutputLevel);
        }
        if (justPrintUsage || justPrintVersion || justPrintDiagnostics) {
            if (justPrintUsage) {
                AntMain.printUsage();
            }
            if (justPrintDiagnostics) {
                Diagnostics.doReport((PrintStream)System.out, (int)this.msgOutputLevel);
            }
            return;
        }
        this.buildFile = new File(BUILD_FILE_NAME);
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        this.buildFile = FileUtils.getFileUtils().normalize(this.buildFile.getAbsolutePath());
        this.loadPropertyFiles();
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        if (logTo != null) {
            out = logTo;
            err = logTo;
            System.setOut(out);
            System.setErr(err);
        }
        this.readyToRun = true;
    }

    private int handleArgListener(String[] args, int pos) {
        try {
            this.listeners.addElement(args[pos + 1]);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "You must specify a classname when using the -listener argument";
            throw new BuildException(msg);
        }
        return ++pos;
    }

    private int handleArgDefine(String[] args, int argPos) {
        String arg = args[argPos];
        String name = arg.substring(2, arg.length());
        String value = null;
        int posEq = name.indexOf("=");
        if (posEq > 0) {
            value = name.substring(posEq + 1);
            name = name.substring(0, posEq);
        } else if (argPos < args.length - 1) {
            value = args[++argPos];
        } else {
            throw new BuildException("Missing value for property " + name);
        }
        this.definedProps.put(name, value);
        return argPos;
    }

    private int handleArgLogger(String[] args, int pos) {
        if (this.loggerClassname != null) {
            throw new BuildException("Only one logger class may be specified.");
        }
        try {
            this.loggerClassname = args[++pos];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new BuildException("You must specify a classname when using the -logger argument");
        }
        return pos;
    }

    private int handleArgInputHandler(String[] args, int pos) {
        if (this.inputHandlerClassname != null) {
            throw new BuildException("Only one input handler class may be specified.");
        }
        try {
            this.inputHandlerClassname = args[++pos];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new BuildException("You must specify a classname when using the -inputhandler argument");
        }
        return pos;
    }

    private int handleArgPropertyFile(String[] args, int pos) {
        try {
            this.propertyFiles.addElement(args[++pos]);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "You must specify a property filename when using the -propertyfile argument";
            throw new BuildException(msg);
        }
        return pos;
    }

    private int handleArgNice(String[] args, int pos) {
        try {
            this.threadPriority = Integer.decode(args[++pos]);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new BuildException("You must supply a niceness value (1-10) after the -nice option");
        }
        catch (NumberFormatException e) {
            throw new BuildException("Unrecognized niceness value: " + args[pos]);
        }
        if (this.threadPriority < 1 || this.threadPriority > 10) {
            throw new BuildException("Niceness value is out of the range 1-10");
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertyFiles() {
        for (int propertyFileIndex = 0; propertyFileIndex < this.propertyFiles.size(); ++propertyFileIndex) {
            String filename = (String)this.propertyFiles.elementAt(propertyFileIndex);
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filename);
                props.load(fis);
            }
            catch (IOException e) {
                try {
                    System.out.println("Could not load property file " + filename + ": " + e.getMessage());
                }
                catch (Throwable throwable) {
                    FileUtils.close(fis);
                    throw throwable;
                }
                FileUtils.close((InputStream)fis);
            }
            FileUtils.close((InputStream)fis);
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (this.definedProps.getProperty(name) != null) continue;
                this.definedProps.put(name, props.getProperty(name));
            }
        }
    }

    private File getParentFile(File file) {
        File parent = file.getParentFile();
        if (parent != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + parent.getAbsolutePath());
        }
        return parent;
    }

    private void runBuild(ClassLoader coreLoader) throws BuildException {
        DeploymentPhase[] lifecycle;
        if (!this.readyToRun) {
            return;
        }
        String deployIdString = this.definedProps.getProperty("rhq.deploy.id");
        if (deployIdString == null) {
            this.definedProps.setProperty("rhq.deploy.id", "0");
        }
        for (DeploymentPhase phase : lifecycle = this.getLifecycle()) {
            System.out.println("***** Executing " + (Object)((Object)phase) + " phase *****...");
            BundleAntProject project = new BundleAntProject();
            Throwable error = null;
            try {
                this.initProject(project, coreLoader, phase);
                if (this.projectHelp) {
                    AntMain.printDescription(project);
                    AntMain.printTargets(project, this.msgOutputLevel > 2);
                    continue;
                }
                if (this.targets.isEmpty() && project.getDefaultTarget() != null) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            catch (RuntimeException exc) {
                error = exc;
                throw exc;
            }
            catch (Error e) {
                error = e;
                throw e;
            }
            finally {
                if (!this.projectHelp) {
                    try {
                        project.fireBuildFinished(error);
                    }
                    catch (Throwable t) {
                        System.err.println("Caught an exception while logging the end of the build.  Exception was:");
                        t.printStackTrace();
                        if (error != null) {
                            System.err.println("There has been an error prior to that:");
                            error.printStackTrace();
                        }
                        throw new BuildException(t);
                    }
                } else if (error != null) {
                    project.log(error.toString(), 0);
                }
            }
        }
    }

    private DeploymentPhase[] getLifecycle() {
        DeploymentPhase[] lifecycle;
        String deployDirString = this.definedProps.getProperty("rhq.deploy.dir");
        if (deployDirString == null) {
            throw new BuildException("Required system property 'rhq.deploy.dir' was not specified. Please set this property to the directory where the bundle should be installed (e.g. -Drhq.deploy.dir=/opt/yourapp).");
        }
        File deployDir = new File(deployDirString);
        DeploymentsMetadata deployMetadata = new DeploymentsMetadata(deployDir);
        boolean isRedeploy = deployMetadata.isManaged();
        String phaseString = this.definedProps.getProperty("rhq.deploy.phase");
        if (phaseString == null) {
            lifecycle = isRedeploy ? DeploymentPhase.REDEPLOY_LIFECYCLE : DeploymentPhase.DEPLOY_LIFECYCLE;
        } else {
            DeploymentPhase phase = DeploymentPhase.valueOf(phaseString.toUpperCase());
            lifecycle = new DeploymentPhase[]{phase};
        }
        return lifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(Project project, ClassLoader coreLoader, DeploymentPhase phase) {
        project.setCoreLoader(coreLoader);
        project.setProperty("rhq.deploy.phase", phase.name());
        this.addBuildListeners(project);
        this.addInputHandler(project);
        PrintStream savedErr = System.err;
        PrintStream savedOut = System.out;
        InputStream savedIn = System.in;
        SecurityManager oldsm = null;
        oldsm = System.getSecurityManager();
        try {
            if (this.allowInput) {
                project.setDefaultInputStream(System.in);
            }
            System.setIn((InputStream)new DemuxInputStream(project));
            System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(project, false)));
            System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
            if (!this.projectHelp) {
                project.fireBuildStarted();
            }
            if (this.threadPriority != null) {
                try {
                    project.log("Setting Ant's thread priority to " + this.threadPriority, 3);
                    Thread.currentThread().setPriority(this.threadPriority);
                }
                catch (SecurityException swallowed) {
                    project.log("A security manager refused to set the -nice value");
                }
            }
            project.init();
            Enumeration<Object> e = this.definedProps.keys();
            while (e.hasMoreElements()) {
                String arg = (String)e.nextElement();
                String value = (String)this.definedProps.get(arg);
                project.setUserProperty(arg, value);
            }
            project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
            project.setUserProperty("ant.file.type", "file");
            project.setKeepGoingMode(this.keepGoingMode);
            if (this.proxy) {
                ProxySetup proxySetup = new ProxySetup(project);
                proxySetup.enableProxies();
            }
            ProjectHelper.configureProject((Project)project, (File)this.buildFile);
        }
        finally {
            if (oldsm != null) {
                System.setSecurityManager(oldsm);
            }
            System.setOut(savedOut);
            System.setErr(savedErr);
            System.setIn(savedIn);
        }
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener((BuildListener)this.createLogger());
        for (int i = 0; i < this.listeners.size(); ++i) {
            String className = (String)this.listeners.elementAt(i);
            BuildListener listener = (BuildListener)ClasspathUtils.newInstance((String)className, (ClassLoader)Main.class.getClassLoader(), BuildListener.class);
            project.setProjectReference((Object)listener);
            project.addBuildListener(listener);
        }
    }

    private void addInputHandler(Project project) throws BuildException {
        DefaultInputHandler handler = null;
        if (this.inputHandlerClassname == null) {
            handler = new DefaultInputHandler();
        } else {
            handler = (InputHandler)ClasspathUtils.newInstance((String)this.inputHandlerClassname, (ClassLoader)Main.class.getClassLoader(), InputHandler.class);
            project.setProjectReference((Object)handler);
        }
        project.setInputHandler((InputHandler)handler);
    }

    private BuildLogger createLogger() {
        DefaultLogger logger = null;
        if (this.loggerClassname != null) {
            try {
                logger = (BuildLogger)ClasspathUtils.newInstance((String)this.loggerClassname, (ClassLoader)Main.class.getClassLoader(), BuildLogger.class);
            }
            catch (BuildException e) {
                System.err.println("The specified logger class " + this.loggerClassname + " could not be used because " + e.getMessage());
                throw new RuntimeException();
            }
        } else {
            logger = new DefaultLogger();
        }
        logger.setMessageOutputLevel(this.msgOutputLevel);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        logger.setEmacsMode(this.emacsMode);
        return logger;
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuilder msg = new StringBuilder();
        msg.append("rhq-ant [options] [target [target2 [target3] ...]]" + lSep);
        msg.append("Options: " + lSep);
        msg.append("  -help, -h              print this message" + lSep);
        msg.append("  -projecthelp, -p       print project help information" + lSep);
        msg.append("  -version               print the version information and exit" + lSep);
        msg.append("  -diagnostics           print information that might be helpful to" + lSep);
        msg.append("                         diagnose or report problems." + lSep);
        msg.append("  -quiet, -q             be extra quiet" + lSep);
        msg.append("  -verbose, -v           be extra verbose" + lSep);
        msg.append("  -debug, -d             print debugging information" + lSep);
        msg.append("  -emacs, -e             produce logging information without adornments" + lSep);
        msg.append("  -lib <path>            specifies a path to search for jars and classes" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("    -l     <file>                ''" + lSep);
        msg.append("  -logger <classname>    the class which is to perform logging" + lSep);
        msg.append("  -listener <classname>  add an instance of class as a project listener" + lSep);
        msg.append("  -noinput               do not allow interactive input" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        msg.append("  -keep-going, -k        execute all targets that do not depend" + lSep);
        msg.append("                         on failed target(s)" + lSep);
        msg.append("  -propertyfile <name>   load all properties from file with -D" + lSep);
        msg.append("                         properties taking precedence" + lSep);
        msg.append("  -inputhandler <class>  the class which will handle input requests" + lSep);
        msg.append("  -nice  number          A niceness value for the main thread:" + lSep + "                         1 (lowest) to 10 (highest); 5 is the default" + lSep);
        msg.append("  -nouserlib             Run ant without using the jar files from" + lSep + "                         ${user.home}/.ant/lib" + lSep);
        msg.append("  -noclasspath           Run ant without using CLASSPATH" + lSep);
        msg.append("  -autoproxy             Java1.5+: use the OS proxy settings" + lSep);
        msg.append("  -main <class>          override Ant's normal entry point");
        System.out.println(msg);
    }

    private static void printVersion(int logLevel) throws BuildException {
        System.out.println(AntMain.getAntVersion());
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties props = new Properties();
                InputStream in = Main.class.getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                StringBuffer msg = new StringBuffer();
                msg.append("Apache Ant version ");
                msg.append(props.getProperty("VERSION"));
                msg.append(" compiled on ");
                msg.append(props.getProperty("DATE"));
                antVersion = msg.toString();
            }
            catch (IOException ioe) {
                throw new BuildException("Could not load the version information:" + ioe.getMessage());
            }
            catch (NullPointerException npe) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static Map removeDuplicateTargets(Map targets) {
        HashMap<Location, Target> locationMap = new HashMap<Location, Target>();
        for (Map.Entry entry : targets.entrySet()) {
            String name = (String)entry.getKey();
            Target target = (Target)entry.getValue();
            Target otherTarget = (Target)locationMap.get(target.getLocation());
            if (otherTarget != null && otherTarget.getName().length() <= name.length()) continue;
            locationMap.put(target.getLocation(), target);
        }
        HashMap<String, Target> ret = new HashMap<String, Target>();
        for (Target target : locationMap.values()) {
            ret.put(target.getName(), target);
        }
        return ret;
    }

    private static void printTargets(Project project, boolean printSubTargets) {
        String defaultTarget;
        int maxLength = 0;
        Map ptargets = AntMain.removeDuplicateTargets(project.getTargets());
        Vector<String> topNames = new Vector<String>();
        Vector<String> topDescriptions = new Vector<String>();
        Vector<String> subNames = new Vector<String>();
        for (Target currentTarget : ptargets.values()) {
            int pos;
            String targetName = currentTarget.getName();
            if (targetName.equals("")) continue;
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                pos = AntMain.findTargetPosition(subNames, targetName);
                subNames.insertElementAt(targetName, pos);
                continue;
            }
            pos = AntMain.findTargetPosition(topNames, targetName);
            topNames.insertElementAt(targetName, pos);
            topDescriptions.insertElementAt(targetDescription, pos);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        AntMain.printTargets(project, topNames, topDescriptions, "Main targets:", maxLength);
        if (topNames.size() == 0) {
            printSubTargets = true;
        }
        if (printSubTargets) {
            AntMain.printTargets(project, subNames, null, "Other targets:", 0);
        }
        if ((defaultTarget = project.getDefaultTarget()) != null && !"".equals(defaultTarget)) {
            project.log("Default target: " + defaultTarget);
        }
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        for (int i = 0; i < names.size() && res == names.size(); ++i) {
            if (name.compareTo((String)names.elementAt(i)) >= 0) continue;
            res = i;
        }
        return res;
    }

    private static void printTargets(Project project, Vector names, Vector descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() <= maxlen) {
            spaces = spaces + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(heading + lSep + lSep);
        for (int i = 0; i < names.size(); ++i) {
            msg.append(" ");
            msg.append(names.elementAt(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.elementAt(i)).length() + 2));
                msg.append(descriptions.elementAt(i));
            }
            msg.append(lSep);
        }
        project.log(msg.toString(), 1);
    }

    static {
        LAUNCH_COMMANDS.add("-lib");
        LAUNCH_COMMANDS.add("-cp");
        LAUNCH_COMMANDS.add("-noclasspath");
        LAUNCH_COMMANDS.add("--noclasspath");
        LAUNCH_COMMANDS.add("-nouserlib");
        LAUNCH_COMMANDS.add("-main");
        out = System.out;
        err = System.err;
        isLogFileUsed = false;
        antVersion = null;
    }
}

