/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.rhq.bundle.ant.type.AbstractBundleType;
import org.rhq.bundle.ant.type.ArchiveType;
import org.rhq.bundle.ant.type.FileSet;
import org.rhq.bundle.ant.type.FileType;
import org.rhq.bundle.ant.type.IgnoreType;
import org.rhq.bundle.ant.type.SystemServiceType;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.Deployer;
import org.rhq.core.util.updater.DeploymentData;
import org.rhq.core.util.updater.DeploymentProperties;

public class DeploymentUnitType
extends AbstractBundleType {
    private String name;
    private Map<File, File> files = new LinkedHashMap<File, File>();
    private Set<File> rawFilesToReplace = new LinkedHashSet<File>();
    private Set<File> archives = new LinkedHashSet<File>();
    private Map<File, Pattern> archiveReplacePatterns = new HashMap<File, Pattern>();
    private SystemServiceType systemService;
    private Pattern ignorePattern;
    private boolean preview;
    private String preinstallTarget;
    private String postinstallTarget;

    public void init() throws BuildException {
        if (this.systemService != null) {
            this.systemService.init();
        }
    }

    public void install(boolean revert, boolean clean) throws BuildException {
        if (this.preinstallTarget != null) {
            Target target = (Target)this.getProject().getTargets().get(this.preinstallTarget);
            if (target == null) {
                throw new BuildException("Specified preinstall target (" + this.preinstallTarget + ") does not exist.");
            }
            target.performTasks();
        }
        int deploymentId = this.getProject().getDeploymentId();
        DeploymentProperties deploymentProps = new DeploymentProperties(deploymentId, this.getProject().getBundleName(), this.getProject().getBundleVersion(), this.getProject().getBundleDescription());
        File deployDir = this.getProject().getDeployDir();
        TemplateEngine templateEngine = this.createTemplateEngine();
        if (this.files.isEmpty() && this.archives.isEmpty()) {
            throw new BuildException("You must specify at least one file to deploy via nested rhq:file, rhq:archive, and/or rhq:system-service elements.");
        }
        if (!this.files.isEmpty()) {
            this.log("Deploying files " + this.files + "...", 3);
        }
        if (!this.archives.isEmpty()) {
            this.log("Deploying archives " + this.archives + "...", 3);
        }
        DeploymentData deploymentData = new DeploymentData(deploymentProps, this.archives, this.files, deployDir, this.archiveReplacePatterns, this.rawFilesToReplace, templateEngine, this.ignorePattern);
        Deployer deployer = new Deployer(deploymentData);
        try {
            DeployDifferences diffs = this.getProject().getDeployDifferences();
            boolean dryRun = this.getProject().isDryRun();
            if (revert) {
                deployer.redeployAndRestoreBackupFiles(diffs, clean, dryRun);
            } else {
                deployer.deploy(diffs, clean, dryRun);
            }
            this.getProject().log("Results:\n" + diffs + "\n");
        }
        catch (Exception e) {
            throw new BuildException("Failed to deploy bundle '" + this.getProject().getBundleName() + "' version " + this.getProject().getBundleVersion() + ": " + e, (Throwable)e);
        }
        if (this.systemService != null) {
            this.systemService.install();
        }
        if (this.postinstallTarget != null) {
            Target target = (Target)this.getProject().getTargets().get(this.postinstallTarget);
            if (target == null) {
                throw new BuildException("Specified postinstall target (" + this.postinstallTarget + ") does not exist.");
            }
            target.performTasks();
        }
    }

    public void start() throws BuildException {
        if (this.systemService != null) {
            this.systemService.start();
        }
    }

    public void stop() throws BuildException {
        if (this.systemService != null) {
            this.systemService.stop();
        }
    }

    public void upgrade(boolean revert, boolean clean) throws BuildException {
        this.install(revert, clean);
    }

    public void uninstall() throws BuildException {
        if (this.systemService != null) {
            this.systemService.uninstall();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<File, File> getFiles() {
        return this.files;
    }

    public Set<File> getArchives() {
        return this.archives;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public String getPreinstallTarget() {
        return this.preinstallTarget;
    }

    public void setPreinstallTarget(String preinstallTarget) {
        this.preinstallTarget = preinstallTarget;
    }

    public String getPostinstallTarget() {
        return this.postinstallTarget;
    }

    public void setPostinstallTarget(String postinstallTarget) {
        this.postinstallTarget = postinstallTarget;
    }

    public void addConfigured(SystemServiceType systemService) {
        if (this.systemService != null) {
            throw new IllegalStateException("A rhq:deploymentUnit element can only have one rhq:system-service child element.");
        }
        this.systemService = systemService;
        this.systemService.validate();
        this.files.put(this.systemService.getScriptFile(), this.systemService.getScriptDestFile());
        if (this.systemService.getConfigFile() != null) {
            this.files.put(this.systemService.getConfigFile(), this.systemService.getConfigDestFile());
            this.rawFilesToReplace.add(this.systemService.getConfigFile());
        }
    }

    public void addConfigured(FileType file) {
        File destFile = file.getDestinationFile();
        if (destFile == null) {
            File destDir = file.getDestinationDir();
            destFile = new File(destDir, file.getSource().getName());
        }
        this.files.put(file.getSource(), destFile);
        if (file.isReplace()) {
            this.rawFilesToReplace.add(file.getSource());
        }
    }

    public void addConfigured(ArchiveType archive) {
        this.archives.add(archive.getSource());
        Pattern replacePattern = archive.getReplacePattern();
        if (replacePattern != null) {
            this.archiveReplacePatterns.put(archive.getSource(), replacePattern);
        }
    }

    public void addConfigured(IgnoreType ignore) {
        List<FileSet> fileSets = ignore.getFileSets();
        this.ignorePattern = DeploymentUnitType.getPattern(fileSets);
    }

    private TemplateEngine createTemplateEngine() {
        TemplateEngine templateEngine = SystemInfoFactory.fetchTemplateEngine();
        Configuration config = this.getProject().getConfiguration();
        for (PropertySimple prop : config.getSimpleProperties().values()) {
            templateEngine.getTokens().put(prop.getName(), prop.getStringValue());
        }
        templateEngine.getTokens().put("rhq.deploy.dir", this.getProject().getProperty("rhq.deploy.dir"));
        return templateEngine;
    }
}

