/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.InvalidBuildFileException;
import org.rhq.bundle.ant.task.BundleTask;
import org.rhq.bundle.ant.type.DeploymentUnitType;

public class AntLauncher {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String ANTCONTRIB_ANT_TASKS = "net/sf/antcontrib/antcontrib.properties";
    private static final String LIQUIBASE_ANT_TASKS = "liquibasetasks.properties";
    private static final String REFID_CONTEXT = "ant.parsing.context";
    private static final String BUNDLE_TASK_NAME = "rhq:bundle";
    private boolean requireExplicitCompliance;

    @Deprecated
    public AntLauncher() {
        this(false);
    }

    public AntLauncher(boolean requireExplicitCompliance) {
        this.requireExplicitCompliance = requireExplicitCompliance;
    }

    public BundleAntProject executeBundleDeployFile(File buildFile, Properties buildProperties, List<BuildListener> buildListeners) throws InvalidBuildFileException {
        BundleAntProject parsedProject = this.parseBundleDeployFile(buildFile, buildProperties);
        BundleAntProject project = this.createProject(buildFile, false, buildProperties);
        project.getBundleFileNames().addAll(parsedProject.getBundleFileNames());
        try {
            if (buildListeners != null) {
                for (BuildListener buildListener : buildListeners) {
                    project.addBuildListener(buildListener);
                }
            }
            this.addTaskDefsForBundledTasks(project);
            ProjectHelper.configureProject((Project)project, (File)buildFile);
            return project;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute bundle deploy file [" + buildFile.getAbsolutePath() + "]. Cause: " + e, e);
        }
    }

    public BundleAntProject parseBundleDeployFile(File buildFile, Properties buildProperties) throws InvalidBuildFileException {
        BundleAntProject project = this.createProject(buildFile, true, buildProperties);
        ProjectHelper2 projectHelper = new ProjectHelper2();
        try {
            AntXMLContext context = (AntXMLContext)project.getReference(REFID_CONTEXT);
            projectHelper.parse((Project)project, (Object)buildFile, new ProjectHelper2.RootHandler(context, (ProjectHelper2.AntHandler)new ProjectHelper2.MainHandler()));
        }
        catch (BuildException e) {
            throw new InvalidBuildFileException("Failed to parse bundle Ant build file.", e);
        }
        this.validateAndPreprocess(project);
        this.log.debug((Object)"==================== PARSED BUNDLE ANT BUILD FILE ====================");
        this.log.debug((Object)(" Bundle Name: " + project.getBundleName()));
        this.log.debug((Object)(" Bundle Version: " + project.getBundleVersion()));
        this.log.debug((Object)(" Bundle Description: " + project.getBundleDescription()));
        this.log.debug((Object)(" Deployment Config Def: " + project.getConfigurationDefinition().getPropertyDefinitions().values()));
        this.log.debug((Object)"======================================================================");
        return project;
    }

    private BundleAntProject createProject(File buildFile, boolean parseOnly, Properties buildProperties) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        BundleAntProject project = new BundleAntProject(parseOnly);
        if (buildProperties != null) {
            for (Map.Entry<Object, Object> property : buildProperties.entrySet()) {
                project.setUserProperty(property.getKey().toString(), property.getValue().toString().replace("\\", "\\\\"));
            }
        }
        project.setUserProperty("ant.file", buildFile.getAbsolutePath());
        project.setUserProperty("ant.file.type", "file");
        project.setCoreLoader(classLoader);
        project.init();
        project.setBaseDir(buildFile.getParentFile());
        AntXMLContext context = new AntXMLContext((Project)project);
        context.setCurrentTargets(new HashMap());
        project.addReference(REFID_CONTEXT, context);
        project.addReference("ant.targets", context.getTargets());
        return project;
    }

    private void addTaskDefsForBundledTasks(BundleAntProject project) throws IOException, ClassNotFoundException {
        Properties taskDefs = this.buildTaskDefProperties(project.getCoreLoader());
        for (Map.Entry<Object, Object> taskDef : taskDefs.entrySet()) {
            project.addTaskDefinition(taskDef.getKey().toString(), Class.forName(taskDef.getValue().toString(), true, project.getCoreLoader()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties buildTaskDefProperties(ClassLoader classLoader) throws IOException {
        HashSet<String> customTaskDefs = new HashSet<String>(2);
        customTaskDefs.add(ANTCONTRIB_ANT_TASKS);
        customTaskDefs.add(LIQUIBASE_ANT_TASKS);
        Properties taskDefProps = new Properties();
        for (String customTaskDef : customTaskDefs) {
            InputStream taskDefsStream = classLoader.getResourceAsStream(customTaskDef);
            if (taskDefsStream != null) {
                try {
                    taskDefProps.load(taskDefsStream);
                    continue;
                }
                catch (Exception e) {
                    this.log.warn((Object)("Ant task definitions [" + customTaskDef + "] failed to load - ant bundles cannot use their tasks"), (Throwable)e);
                    continue;
                }
                finally {
                    taskDefsStream.close();
                    continue;
                }
            }
            this.log.warn((Object)("Missing ant task definitions [" + customTaskDef + "] - ant bundles cannot use their tasks"));
        }
        return taskDefProps;
    }

    private void validateAndPreprocess(BundleAntProject project) throws InvalidBuildFileException {
        AntXMLContext antParsingContext = (AntXMLContext)project.getReference(REFID_CONTEXT);
        Vector targets = antParsingContext.getTargets();
        int bundleTaskCount = 0;
        Task unconfiguredBundleTask = null;
        for (Object targetObj : targets) {
            Task[] tasks;
            Target target = (Target)targetObj;
            for (Task task : tasks = target.getTasks()) {
                if (!task.getTaskName().equals(BUNDLE_TASK_NAME)) continue;
                this.abortIfTaskWithinTarget(target, task);
                ++bundleTaskCount;
                unconfiguredBundleTask = task;
            }
        }
        if (bundleTaskCount == 0) {
            throw new InvalidBuildFileException("rhq:bundle task not found - an RHQ bundle Ant build file must contain exactly one rhq:bundle task.");
        }
        if (bundleTaskCount > 1) {
            throw new InvalidBuildFileException("More than one rhq:bundle task found - an RHQ bundle Ant build file must contain exactly one rhq:bundle task.");
        }
        BundleTask bundleTask = (BundleTask)AntLauncher.preconfigureTask(unconfiguredBundleTask);
        Collection<DeploymentUnitType> deployments = bundleTask.getDeploymentUnits().values();
        if (deployments.isEmpty()) {
            throw new InvalidBuildFileException("The bundle task must contain exactly one rhq:deploymentUnit child element.");
        }
        DeploymentUnitType deployment = deployments.iterator().next();
        if (this.requireExplicitCompliance && deployment.getCompliance() == null) {
            throw new InvalidBuildFileException("The deployment unit must specifically declare compliance mode of the destination directory.");
        }
        project.setDestinationCompliance(deployment.getCompliance());
        Map<File, String> files = deployment.getLocalFileNames();
        for (String file : files.values()) {
            project.getBundleFileNames().add(file);
        }
        Map<File, String> archives = deployment.getLocalArchiveNames();
        for (String archive : archives.values()) {
            project.getBundleFileNames().add(archive);
        }
    }

    private void abortIfTaskWithinTarget(Target target, Task task) throws InvalidBuildFileException {
        if (!target.getName().equals("")) {
            throw new InvalidBuildFileException(task.getTaskName() + " task found within [" + target.getName() + "] target - it must be outside of any targets (at the top of the build file).");
        }
    }

    private static Task preconfigureTask(Task task) {
        if (task instanceof UnknownElement) {
            task.maybeConfigure();
            Task resolvedTask = ((UnknownElement)task).getTask();
            return resolvedTask != null ? resolvedTask : task;
        }
        return task;
    }
}

