/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.task;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.rhq.bundle.ant.DeploymentPhase;
import org.rhq.bundle.ant.task.AbstractBundleTask;
import org.rhq.bundle.ant.type.DeploymentUnitType;
import org.rhq.bundle.ant.type.InputPropertyType;

public class BundleTask
extends AbstractBundleTask {
    private String name;
    private String version;
    private String description;
    private Map<String, DeploymentUnitType> deploymentUnits = new HashMap<String, DeploymentUnitType>();

    public void maybeConfigure() throws BuildException {
        super.maybeConfigure();
        this.validateAttributes();
        this.getProject().setBundleName(this.name);
        this.getProject().setBundleVersion(this.version);
        this.getProject().setBundleDescription(this.description);
    }

    public void execute() throws BuildException {
        DeploymentPhase deploymentPhase;
        int deploymentId;
        Hashtable projectProps = this.getProject().getProperties();
        String deployDir = (String)projectProps.get("rhq.deploy.dir");
        if (deployDir == null) {
            throw new BuildException("Required property [rhq.deploy.dir] was not specified.");
        }
        File deployDirFile = new File(deployDir);
        if (!deployDirFile.isAbsolute() && !deployDirFile.getPath().startsWith(File.separator)) {
            throw new BuildException("Value of property [rhq.deploy.dir] (" + deployDirFile + ") is not an absolute path.");
        }
        this.getProject().setDeployDir(deployDirFile);
        this.log("rhq.deploy.dir=\"" + deployDir + "\"", 4);
        String deploymentIdStr = (String)projectProps.get("rhq.deploy.id");
        if (deploymentIdStr == null) {
            throw new BuildException("Required property [rhq.deploy.id] was not specified.");
        }
        try {
            deploymentId = Integer.parseInt(deploymentIdStr);
        }
        catch (Exception e) {
            throw new BuildException("Value of property [rhq.deploy.id] (" + deploymentIdStr + ") is not valid.", (Throwable)e);
        }
        this.getProject().setDeploymentId(deploymentId);
        this.log("rhq.deploy.id=\"" + deploymentId + "\"", 4);
        if (this.deploymentUnits.size() != 1) {
            throw new BuildException("The rhq:bundle task must contain exactly one rhq:deploymentUnit element.");
        }
        DeploymentUnitType deploymentUnit = this.deploymentUnits.values().iterator().next();
        String deploymentPhaseName = (String)projectProps.get("rhq.deploy.phase");
        if (deploymentPhaseName == null) {
            throw new BuildException("Required property [rhq.deploy.phase] was not specified.");
        }
        try {
            deploymentPhase = DeploymentPhase.valueOf(deploymentPhaseName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            DeploymentPhase[] phases = DeploymentPhase.values();
            ArrayList<String> validPhaseNames = new ArrayList<String>(phases.length);
            for (DeploymentPhase phase : phases) {
                validPhaseNames.add(phase.name().toLowerCase());
            }
            throw new BuildException("Value of property 'rhq.deploy.phase' (" + deploymentPhaseName + ") is not a valid deployment phase - the valid phases are " + validPhaseNames + ".");
        }
        this.getProject().setDeploymentPhase(deploymentPhase);
        String dryRunString = (String)projectProps.get("rhq.deploy.dryRun");
        boolean dryRun = Boolean.valueOf(dryRunString);
        this.getProject().setDryRun(dryRun);
        String revertString = (String)projectProps.get("rhq.deploy.revert");
        boolean revert = Boolean.valueOf(revertString);
        String cleanString = (String)projectProps.get("rhq.deploy.clean");
        boolean clean = Boolean.valueOf(cleanString);
        this.log("Executing '" + (Object)((Object)deploymentPhase) + "' phase for deployment with id [" + deploymentId + "] from bundle '" + this.name + "' version " + this.version + " using config " + this.getProject().getConfiguration().toString(true) + " [dryRun=" + dryRun + ", revert=" + revert + ", clean=" + clean + "]...");
        deploymentUnit.init();
        switch (deploymentPhase) {
            case INSTALL: {
                deploymentUnit.install(revert, clean);
                break;
            }
            case START: {
                deploymentUnit.start();
                break;
            }
            case STOP: {
                deploymentUnit.stop();
                break;
            }
            case UPGRADE: {
                deploymentUnit.upgrade(revert, clean);
                break;
            }
            case UNINSTALL: {
                deploymentUnit.uninstall();
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addConfigured(InputPropertyType inputProperty) {
        inputProperty.init();
    }

    public void add(DeploymentUnitType deployment) {
        this.deploymentUnits.put(deployment.getName(), deployment);
    }

    public Map<String, DeploymentUnitType> getDeploymentUnits() {
        return this.deploymentUnits;
    }

    protected void validateAttributes() throws BuildException {
        if (this.name == null) {
            throw new BuildException("The 'name' attribute is required.");
        }
        if (this.name.length() == 0) {
            throw new BuildException("The 'name' attribute must have a non-empty value.");
        }
        if (this.version == null) {
            throw new BuildException("The 'version' attribute is required.");
        }
        if (this.version.length() == 0) {
            throw new BuildException("The 'version' attribute must have a non-empty value.");
        }
    }

    protected void validateTypes() throws BuildException {
        if (this.deploymentUnits.isEmpty()) {
            throw new BuildException("At least one 'rhq:deploymentUnit' child element must be specified.");
        }
    }
}

