/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.ant.AntLauncher;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.LoggerAntBuildListener;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.plugins.ant.DeploymentAuditorBuildListener;

public class AntBundlePluginComponent
implements ResourceComponent,
BundleFacet {
    private final Log log = LogFactory.getLog(AntBundlePluginComponent.class);
    private ResourceContext resourceContext;
    private File tmpDirectory;

    public void start(ResourceContext context) throws Exception {
        this.resourceContext = context;
        this.tmpDirectory = new File(context.getTemporaryDirectory(), "ant-bundle-plugin");
        this.tmpDirectory.mkdirs();
        if (!this.tmpDirectory.exists() || !this.tmpDirectory.isDirectory()) {
            throw new Exception("Failed to create tmp dir [" + this.tmpDirectory + "] - cannot process Ant bundles.");
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public BundleDeployResult deployBundle(BundleDeployRequest request) {
        BundleDeployResult result = new BundleDeployResult();
        try {
            BundleResourceDeployment resourceDeployment = request.getResourceDeployment();
            BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
            BundleVersion bundleVersion = bundleDeployment.getBundleVersion();
            String recipe = bundleVersion.getRecipe();
            File recipeFile = File.createTempFile("ant-bundle-recipe", ".xml", request.getBundleFilesLocation());
            File logFile = File.createTempFile("ant-bundle-recipe", ".log", this.tmpDirectory);
            PrintWriter logFileOutput = null;
            try {
                logFileOutput = new PrintWriter(new FileOutputStream(logFile, true));
                ByteArrayInputStream in = new ByteArrayInputStream(recipe.getBytes());
                FileOutputStream out = new FileOutputStream(recipeFile);
                StreamUtil.copy((InputStream)in, (OutputStream)out);
                Properties antProps = this.createAntProperties(bundleDeployment);
                ArrayList<Object> buildListeners = new ArrayList<Object>();
                LoggerAntBuildListener logger = new LoggerAntBuildListener(null, logFileOutput, 4);
                buildListeners.add(logger);
                DeploymentAuditorBuildListener auditor = new DeploymentAuditorBuildListener(request.getBundleManagerProvider(), resourceDeployment);
                buildListeners.add(auditor);
                AntLauncher antLauncher = new AntLauncher();
                BundleAntProject project = antLauncher.executeBundleDeployFile(recipeFile, null, antProps, buildListeners);
                BundleManagerProvider bundleManagerProvider = request.getBundleManagerProvider();
                DeployDifferences diffs = project.getDeployDifferences();
                bundleManagerProvider.auditDeployment(resourceDeployment, "Deployment Differences", BundleDeploymentStatus.SUCCESS, diffs.toString());
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    try {
                        this.log.debug((Object)new String(StreamUtil.slurp((InputStream)new FileInputStream(logFile))));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw new Exception("Failed to execute the bundle Ant script", t);
            }
            finally {
                if (logFileOutput != null) {
                    logFileOutput.close();
                }
                recipeFile.delete();
                logFile.delete();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to deploy bundle [" + request + "]"), t);
            result.setErrorMessage(t);
        }
        return result;
    }

    private Properties createAntProperties(BundleDeployment bundleDeployment) {
        Properties antProps = new Properties();
        String installDir = bundleDeployment.getInstallDir();
        if (installDir == null) {
            throw new IllegalStateException("Bundle deployment does not specify install dir: " + bundleDeployment);
        }
        antProps.setProperty("rhq.deploy.dir", installDir);
        int deploymentId = bundleDeployment.getId();
        antProps.setProperty("rhq.deploy.id", Integer.toString(deploymentId));
        Map sysFacts = SystemInfoFactory.fetchTemplateEngine().getTokens();
        for (Map.Entry fact : sysFacts.entrySet()) {
            antProps.setProperty((String)fact.getKey(), (String)fact.getValue());
        }
        Configuration config = bundleDeployment.getConfiguration();
        if (config != null) {
            Map allProperties = config.getAllProperties();
            for (Map.Entry entry : allProperties.entrySet()) {
                String name = (String)entry.getKey();
                Property prop = (Property)entry.getValue();
                if (!(prop instanceof PropertySimple)) continue;
                String value = ((PropertySimple)prop).getStringValue();
                antProps.setProperty(name, value);
            }
        }
        return antProps;
    }
}

