/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildListener;
import org.rhq.bundle.ant.AntLauncher;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.DeploymentPhase;
import org.rhq.bundle.ant.InvalidBuildFileException;
import org.rhq.bundle.ant.LoggerAntBuildListener;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.DeploymentsMetadata;
import org.rhq.plugins.ant.DeploymentAuditorBuildListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntBundlePluginComponent
implements ResourceComponent,
BundleFacet {
    private final Log log = LogFactory.getLog(AntBundlePluginComponent.class);
    private ResourceContext resourceContext;
    private File tmpDirectory;

    public void start(ResourceContext context) throws Exception {
        this.resourceContext = context;
        this.tmpDirectory = new File(context.getTemporaryDirectory(), "ant-bundle-plugin");
        this.tmpDirectory.mkdirs();
        if (!this.tmpDirectory.exists() || !this.tmpDirectory.isDirectory()) {
            throw new Exception("Failed to create tmp dir [" + this.tmpDirectory + "] - cannot process Ant bundles.");
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public BundleDeployResult deployBundle(BundleDeployRequest request) {
        BundleDeployResult result = new BundleDeployResult();
        try {
            BundleResourceDeployment resourceDeployment = request.getResourceDeployment();
            BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
            BundleVersion bundleVersion = bundleDeployment.getBundleVersion();
            String recipe = bundleVersion.getRecipe();
            File recipeFile = File.createTempFile("ant-bundle-recipe", ".xml", request.getBundleFilesLocation());
            File logFile = File.createTempFile("ant-bundle-recipe", ".log", this.tmpDirectory);
            PrintWriter logFileOutput = null;
            try {
                logFileOutput = new PrintWriter(new FileOutputStream(logFile, true));
                ByteArrayInputStream in = new ByteArrayInputStream(recipe.getBytes());
                FileOutputStream out = new FileOutputStream(recipeFile);
                StreamUtil.copy((InputStream)in, (OutputStream)out);
                Properties antProps = this.createAntProperties(request);
                ArrayList<BuildListener> buildListeners = new ArrayList<BuildListener>();
                LoggerAntBuildListener logger = new LoggerAntBuildListener(null, logFileOutput, 4);
                buildListeners.add((BuildListener)logger);
                DeploymentAuditorBuildListener auditor = new DeploymentAuditorBuildListener(request.getBundleManagerProvider(), resourceDeployment);
                buildListeners.add(auditor);
                this.executeDeploymentPhase(recipeFile, antProps, buildListeners, DeploymentPhase.STOP);
                String deployDirString = bundleDeployment.getDestination().getDeployDir();
                File deployDir = new File(deployDirString);
                DeploymentsMetadata deployMetadata = new DeploymentsMetadata(deployDir);
                DeploymentPhase installPhase = deployMetadata.isManaged() ? DeploymentPhase.UPGRADE : DeploymentPhase.INSTALL;
                BundleAntProject project = this.executeDeploymentPhase(recipeFile, antProps, buildListeners, installPhase);
                this.executeDeploymentPhase(recipeFile, antProps, buildListeners, DeploymentPhase.START);
                BundleManagerProvider bundleManagerProvider = request.getBundleManagerProvider();
                DeployDifferences diffs = project.getDeployDifferences();
                bundleManagerProvider.auditDeployment(resourceDeployment, "Deployment Differences", project.getName(), BundleResourceDeploymentHistory.Category.DEPLOY_STEP, null, diffs.toString(), null);
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    try {
                        this.log.debug((Object)new String(StreamUtil.slurp((InputStream)new FileInputStream(logFile))));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw new Exception("Failed to execute the bundle Ant script", t);
            }
            finally {
                if (logFileOutput != null) {
                    logFileOutput.close();
                }
                recipeFile.delete();
                logFile.delete();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to deploy bundle [" + request + "]"), t);
            result.setErrorMessage(t);
        }
        return result;
    }

    private BundleAntProject executeDeploymentPhase(File recipeFile, Properties antProps, List<BuildListener> buildListeners, DeploymentPhase phase) throws InvalidBuildFileException {
        AntLauncher antLauncher = new AntLauncher();
        antProps.setProperty("rhq.deploy.phase", phase.name());
        BundleAntProject project = antLauncher.executeBundleDeployFile(recipeFile, antProps, buildListeners);
        return project;
    }

    private Properties createAntProperties(BundleDeployRequest request) {
        Properties antProps = new Properties();
        BundleResourceDeployment resourceDeployment = request.getResourceDeployment();
        BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
        String deployDir = bundleDeployment.getDestination().getDeployDir();
        if (deployDir == null) {
            throw new IllegalStateException("Bundle deployment does not specify install dir: " + bundleDeployment);
        }
        antProps.setProperty("rhq.deploy.dir", deployDir);
        int deploymentId = bundleDeployment.getId();
        antProps.setProperty("rhq.deploy.id", Integer.toString(deploymentId));
        antProps.setProperty("rhq.deploy.name", bundleDeployment.getName());
        antProps.setProperty("rhq.deploy.revert", String.valueOf(request.isRevert()));
        antProps.setProperty("rhq.deploy.clean", String.valueOf(request.isCleanDeployment()));
        Map sysFacts = SystemInfoFactory.fetchTemplateEngine().getTokens();
        for (Map.Entry fact : sysFacts.entrySet()) {
            antProps.setProperty((String)fact.getKey(), (String)fact.getValue());
        }
        Configuration config = bundleDeployment.getConfiguration();
        if (config != null) {
            Map allProperties = config.getAllProperties();
            for (Map.Entry entry : allProperties.entrySet()) {
                String name = (String)entry.getKey();
                Property prop = (Property)entry.getValue();
                if (!(prop instanceof PropertySimple)) continue;
                String value = ((PropertySimple)prop).getStringValue();
                antProps.setProperty(name, value);
            }
        }
        return antProps;
    }
}

