/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsProcessUtility {
    private static final String[] NO_ARGS = new String[0];
    private static final List<String> NO_MODULES = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static File getProcExe(long pid, String name) {
        String module;
        Sigar sigar;
        block11: {
            File file;
            sigar = new Sigar();
            try {
                String exe = sigar.getProcExe(pid).getName();
                if (exe.length() <= 0) break block11;
                file = new File(exe);
            }
            catch (SigarException e) {
                // empty catch block
                break block11;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            sigar.close();
            return file;
        }
        File argv0 = null;
        String[] args = OsProcessUtility.getProcArgs(pid, sigar);
        if (args.length != 0 && (argv0 = new File(args[0])).exists() && argv0.isAbsolute()) {
            return argv0;
        }
        List<String> modules = OsProcessUtility.getProcModules(pid, sigar);
        if (modules.size() <= 0) return argv0;
        if (name == null) {
            return new File(modules.get(0));
        }
        name = File.separator + name;
        Iterator<String> i$ = modules.iterator();
        do {
            if (!i$.hasNext()) return argv0;
        } while (!(module = i$.next()).endsWith(name));
        return new File(module);
    }

    @NotNull
    private static String[] getProcArgs(long pid, Sigar sigar) {
        try {
            return sigar.getProcArgs(pid);
        }
        catch (SigarException e) {
            return NO_ARGS;
        }
    }

    @NotNull
    private static List<String> getProcModules(long pid, Sigar sigar) {
        try {
            return sigar.getProcModules(pid);
        }
        catch (SigarException e) {
            return NO_MODULES;
        }
    }

    private OsProcessUtility() {
    }
}

