/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;
import org.rhq.plugins.apache.util.OsProcessUtility;
import org.rhq.plugins.www.snmp.SNMPClient;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheServerDiscoveryComponent
implements ResourceDiscoveryComponent {
    private static final String PRODUCT_DESCRIPTION = "Apache Web Server";
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List processes = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult process : processes) {
            ApacheBinaryInfo binaryInfo;
            String executableName = ApacheServerDiscoveryComponent.getExecutableName(process);
            File executablePath = OsProcessUtility.getProcExe(process.getProcessInfo().getPid(), executableName);
            if (executablePath == null) {
                this.log.error((Object)("Executable path could not be determined for Apache [" + process.getProcessInfo() + "]."));
                continue;
            }
            if (!executablePath.isAbsolute()) {
                this.log.error((Object)("Executable path (" + executablePath + ") is not absolute for Apache [" + process.getProcessInfo() + "]." + "Please restart Apache specifying an absolute path for the executable."));
                continue;
            }
            this.log.debug((Object)("Apache executable path: " + executablePath));
            try {
                binaryInfo = ApacheBinaryInfo.getInfo(executablePath.getPath(), discoveryContext.getSystemInformation());
            }
            catch (Exception e) {
                this.log.error((Object)("'" + executablePath + "' is not a valid Apache executable (" + e + ")."));
                continue;
            }
            if (!this.isSupportedVersion(binaryInfo.getVersion())) continue;
            String serverRoot = this.getServerRoot(binaryInfo, process.getProcessInfo());
            if (serverRoot == null) {
                this.log.error((Object)("Unable to determine server root for Apache process: " + process.getProcessInfo()));
                continue;
            }
            Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
            PropertySimple executablePathProp = new PropertySimple("executablePath", (Object)executablePath);
            pluginConfig.put((Property)executablePathProp);
            PropertySimple serverRootProp = new PropertySimple("serverRoot", (Object)serverRoot);
            pluginConfig.put((Property)serverRootProp);
            String url = ApacheServerDiscoveryComponent.getUrl(pluginConfig);
            PropertySimple urlProp = new PropertySimple("url", (Object)url);
            pluginConfig.put((Property)urlProp);
            PropertySimple configFile = new PropertySimple("configFile", (Object)binaryInfo.getCtl());
            pluginConfig.put((Property)configFile);
            discoveredResources.add(this.createResourceDetails(discoveryContext, pluginConfig, process.getProcessInfo(), binaryInfo));
        }
        List pluginConfigs = discoveryContext.getPluginConfigurations();
        for (Configuration pluginConfig : pluginConfigs) {
            ApacheBinaryInfo binaryInfo;
            String serverRoot = ApacheServerComponent.getRequiredPropertyValue(pluginConfig, "serverRoot");
            if (!new File(serverRoot).isDirectory()) {
                throw new InvalidPluginConfigurationException("'" + serverRoot + "' is not a directory. Please make sure the '" + "serverRoot" + "' connection property is set correctly.");
            }
            String executablePath = pluginConfig.getSimpleValue("executablePath", ApacheServerComponent.DEFAULT_EXECUTABLE_PATH);
            String absoluteExecutablePath = ApacheServerComponent.resolvePathRelativeToServerRoot(pluginConfig, executablePath).getPath();
            try {
                binaryInfo = ApacheBinaryInfo.getInfo(absoluteExecutablePath, discoveryContext.getSystemInformation());
            }
            catch (Exception e) {
                throw new InvalidPluginConfigurationException("'" + absoluteExecutablePath + "' is not a valid Apache executable (" + e + "). Please make sure the '" + "executablePath" + "' connection property is set correctly.");
            }
            if (!this.isSupportedVersion(binaryInfo.getVersion())) {
                throw new InvalidPluginConfigurationException("Version of Apache executable (" + binaryInfo.getVersion() + ") is not a supported version; supported versions are 1.3.x and 2.x.");
            }
            ProcessInfo processInfo = null;
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfig, processInfo, binaryInfo);
            discoveredResources.add(resourceDetails);
        }
        return discoveredResources;
    }

    private boolean isSupportedVersion(String version) {
        return version != null && (version.startsWith("1.3") || version.startsWith("2."));
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfig, ProcessInfo processInfo, ApacheBinaryInfo binaryInfo) throws Exception {
        String serverRoot = pluginConfig.getSimple("serverRoot").getStringValue();
        String key = FileUtils.getCanonicalPath((String)serverRoot);
        String version = binaryInfo.getVersion();
        String hostname = discoveryContext.getSystemInformation().getHostname();
        String name = hostname + " Apache " + version + " (" + serverRoot + File.separator + ")";
        DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, PRODUCT_DESCRIPTION, pluginConfig, processInfo);
        this.log.debug((Object)("Apache Server resource details created: " + resourceDetails));
        return resourceDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getUrl(Configuration pluginConfig) throws Exception {
        SNMPClient snmpClient = new SNMPClient();
        try {
            SNMPValue portValue;
            SNMPValue nameValue;
            SNMPSession snmpSession = ApacheServerComponent.getSNMPSession(snmpClient, pluginConfig);
            if (!snmpSession.ping()) {
                String string = null;
                return string;
            }
            try {
                nameValue = snmpSession.getNextValue("wwwServiceName");
            }
            catch (SNMPException e) {
                throw new Exception("Error getting SNMP value: wwwServiceName: " + e.getMessage(), e);
            }
            try {
                portValue = snmpSession.getNextValue("wwwServiceProtocol");
            }
            catch (SNMPException e) {
                throw new Exception("Error getting SNMP column: wwwServiceProtocol: " + e.getMessage(), e);
            }
            String host = nameValue.toString();
            String fullPort = portValue.toString();
            int port = Integer.parseInt(fullPort.substring(fullPort.lastIndexOf(".") + 1));
            String string = "http://" + host + ":" + port + "/";
            return string;
        }
        finally {
            snmpClient.close();
        }
    }

    @Nullable
    private String getServerRoot(@NotNull ApacheBinaryInfo binaryInfo, @NotNull ProcessInfo processInfo) {
        String root = null;
        String[] cmdLine = processInfo.getCommandLine();
        for (int i = 1; i < cmdLine.length; ++i) {
            String arg = cmdLine[i];
            if (!arg.startsWith("-d")) continue;
            root = arg.substring(2, arg.length());
            if (root.length() != 0) break;
            root = cmdLine[i + 1];
            break;
        }
        if (root == null) {
            root = binaryInfo.getRoot();
        }
        if (root != null) {
            root = FileUtils.getCanonicalPath((String)root);
        }
        return root;
    }

    private static String getExecutableName(ProcessScanResult processScanResult) {
        String query = processScanResult.getProcessScan().getQuery().toLowerCase();
        String executableName = query.contains("apache.exe") ? "apache.exe" : (query.contains("httpd.exe") ? "httpd.exe" : (query.contains("apache2") ? "apache2" : (query.contains("httpd") ? "httpd" : null)));
        return executableName;
    }
}

