/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheVirtualHostServiceDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheServerComponent> {
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheServerComponent> discoveryContext) throws Exception {
        SNMPValue descValue;
        List<SNMPValue> portValues;
        List<SNMPValue> nameValues;
        SNMPSession snmpSession = ((ApacheServerComponent)discoveryContext.getParentResourceComponent()).getSNMPSession();
        try {
            nameValues = snmpSession.getColumn("wwwServiceName");
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP column: wwwServiceName: " + e.getMessage(), e);
        }
        try {
            portValues = snmpSession.getColumn("wwwServiceProtocol");
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP column: wwwServiceProtocol: " + e.getMessage(), e);
        }
        try {
            descValue = snmpSession.getNextValue("wwwServiceDescription");
        }
        catch (SNMPException e) {
            throw new Exception("Error getting SNMP value: wwwServiceDescription: " + e.getMessage(), e);
        }
        ApacheServerComponent parentApacheComponent = (ApacheServerComponent)discoveryContext.getParentResourceComponent();
        File configPath = parentApacheComponent.getServerRoot();
        File logsDir = new File(configPath, "logs");
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        for (int i = 0; i < nameValues.size(); ++i) {
            SNMPValue nameValue = nameValues.get(i);
            String host = nameValue.toString();
            SNMPValue portValue = portValues.get(i);
            String fullPort = portValue.toString();
            String port = fullPort.substring(fullPort.lastIndexOf(".") + 1);
            String key = host + ":" + port;
            String name = "Virtual Host " + key;
            String version = null;
            String desc = descValue.toString();
            DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, desc, null, null);
            Configuration pluginConfig = resourceDetails.getPluginConfiguration();
            String nameOID = nameValue.getOID();
            String wwwServiceIndex = nameOID.substring(nameOID.lastIndexOf(".") + 1);
            PropertySimple wwwServiceIndexProp = new PropertySimple("snmpWwwServiceIndex", (Object)wwwServiceIndex);
            pluginConfig.put((Property)wwwServiceIndexProp);
            String url = "http://" + host + ":" + port + "/";
            PropertySimple urlProp = new PropertySimple("url", (Object)url);
            pluginConfig.put((Property)urlProp);
            String rtLogFileName = host + port + RT_LOG_FILE_NAME_SUFFIX;
            File rtLogFile = new File(logsDir, rtLogFileName);
            pluginConfig.put((Property)new PropertySimple("responseTimeLogFile", (Object)rtLogFile));
            this.log.debug((Object)("Plugin config: " + pluginConfig));
            discoveredResources.add(resourceDetails);
        }
        return discoveredResources;
    }
}

