/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpdAddressUtility {
    APACHE_1_3{

        public Address getMainServerSampleAddress(AugeasTree ag) {
            try {
                Address addr = null;
                List serverNameNodes = ag.matchRelative(ag.getRootNode(), "ServerName");
                if (serverNameNodes.size() > 0) {
                    String serverName = ((AugeasNode)((AugeasNode)serverNameNodes.get(0)).getChildByLabel("param").get(0)).getValue();
                    addr = Address.parse(serverName);
                } else {
                    List ports = ag.matchRelative(ag.getRootNode(), "Port/param");
                    List bindAddresses = ag.matchRelative(ag.getRootNode(), "BindAddress/param");
                    List listens = ag.matchRelative(ag.getRootNode(), "Listen/param");
                    String port = null;
                    String bindAddress = null;
                    String listen = null;
                    if (ports.size() > 0) {
                        port = ((AugeasNode)ports.get(0)).getValue();
                    }
                    if (bindAddresses.size() > 0) {
                        bindAddress = ((AugeasNode)bindAddresses.get(0)).getValue();
                    }
                    if (listens.size() > 0) {
                        listen = ((AugeasNode)listens.get(0)).getValue();
                    }
                    String host = null;
                    int portToUse = -1;
                    if (bindAddress != null && !"*".equals(bindAddress)) {
                        host = bindAddress;
                    }
                    if (port != null) {
                        portToUse = Integer.parseInt(port);
                    }
                    if (listen != null) {
                        Address tmp = Address.parse(listen);
                        host = tmp.host;
                        portToUse = tmp.port;
                        if (portToUse == -1) {
                            host = null;
                            portToUse = Integer.parseInt(tmp.host);
                        }
                    }
                    if (host == null) {
                        host = InetAddress.getLocalHost().getHostName();
                    }
                    addr = new Address(host, portToUse);
                }
                return addr;
            }
            catch (Exception e) {
                log.info((Object)"Failed to obtain main server address. Is augeas installed and correct lens in use?");
                return null;
            }
        }
    }
    ,
    APACHE_2_x{

        public Address getMainServerSampleAddress(AugeasTree ag) {
            try {
                Address addr = null;
                List serverNameNodes = ag.matchRelative(ag.getRootNode(), "ServerName");
                if (serverNameNodes.size() > 0) {
                    String serverName = ((AugeasNode)((AugeasNode)serverNameNodes.get(0)).getChildByLabel("param").get(0)).getValue();
                    addr = Address.parse(serverName);
                } else {
                    AugeasNode listen = (AugeasNode)ag.matchRelative(ag.getRootNode(), "Listen").get(0);
                    List params = listen.getChildByLabel("param");
                    String address = ((AugeasNode)params.get(0)).getValue();
                    addr = Address.parse(address);
                    if (addr.port == -1) {
                        addr.port = Integer.parseInt(addr.host);
                        try {
                            addr.host = InetAddress.getLocalHost().getHostName();
                        }
                        catch (UnknownHostException e) {
                            throw new IllegalStateException("Unable to get the localhost address.", e);
                        }
                    }
                }
                return addr;
            }
            catch (Exception e) {
                log.info((Object)"Failed to obtain main server address. Is augeas installed and correct lens in use?");
                return null;
            }
        }
    };

    private static final Log log;

    public static HttpdAddressUtility get(String version) {
        return version.startsWith("1.") ? APACHE_1_3 : APACHE_2_x;
    }

    public abstract Address getMainServerSampleAddress(AugeasTree var1);

    public Address getVirtualHostSampleAddress(AugeasTree ag, String virtualHost, String serverName) {
        Address addr = Address.parse(virtualHost);
        if (addr.port == -1) {
            Address serverAddr = this.getMainServerSampleAddress(ag);
            if (serverAddr == null) {
                return null;
            }
            addr.port = Integer.parseInt(addr.host);
            addr.host = serverAddr.host;
        } else {
            String host = addr.host;
            if ("*".equals(host) || "_default_".equals(host)) {
                Address serverAddr = this.getMainServerSampleAddress(ag);
                if (serverAddr == null) {
                    return null;
                }
                host = serverAddr.host;
            }
            addr.host = host;
        }
        if (serverName != null) {
            int colonIdx = serverName.indexOf(58);
            if (colonIdx >= 0) {
                addr.host = serverName.substring(0, colonIdx);
                addr.port = Integer.parseInt(serverName.substring(colonIdx + 1));
            } else {
                addr.host = serverName;
            }
            addr.host = addr.host.replaceAll("\\*", "replaced-wildcard");
        }
        return addr;
    }

    static {
        log = LogFactory.getLog(HttpdAddressUtility.class);
    }

    public static class Address {
        public String host;
        public int port = -1;

        public Address(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public static Address parse(String address) {
            int lastColonIdx = address.lastIndexOf(58);
            if (lastColonIdx == -1) {
                return new Address(address, -1);
            }
            int lastRightBracketPos = address.lastIndexOf(93);
            if (lastColonIdx > lastRightBracketPos) {
                String host = address.substring(0, lastColonIdx);
                int port = Integer.parseInt(address.substring(lastColonIdx + 1));
                return new Address(host, port);
            }
            return new Address(address, -1);
        }

        public int hashCode() {
            int hash = this.port;
            if (this.host != null) {
                hash *= this.host.hashCode();
            }
            return hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Address)) {
                return false;
            }
            Address o = (Address)other;
            if (this.host == null) {
                return o.host == null && this.port == o.port;
            }
            return this.host.equals(o.host) && this.port == o.port;
        }
    }
}

