/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rhq.augeas.util.Glob;
import org.rhq.plugins.apache.parser.ApacheConfigReader;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveStack;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.parser.ApacheParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheParserImpl
implements ApacheParser {
    private ApacheDirectiveStack stack = new ApacheDirectiveStack();
    private static String INCLUDE_DIRECTIVE = "Include";
    private String serverRootPath;
    private ApacheDirectiveTree tree;

    public ApacheParserImpl(ApacheDirectiveTree tree, String serverRootPath) {
        this.serverRootPath = serverRootPath;
        this.tree = tree;
        this.stack.addDirective(this.tree.getRootNode());
    }

    @Override
    public void addDirective(ApacheDirective directive) throws Exception {
        if (directive.getName().equals(INCLUDE_DIRECTIVE)) {
            List<File> files = this.getIncludeFiles(directive.getValuesAsString());
            for (File fl : files) {
                ApacheConfigReader.searchFile(fl.getAbsolutePath(), this);
            }
        }
        directive.setParentNode(this.stack.getLastDirective());
        this.stack.getLastDirective().addChildDirective(directive);
    }

    @Override
    public void endNestedDirective(ApacheDirective directive) {
        this.stack.removeLastDirective();
    }

    @Override
    public void startNestedDirective(ApacheDirective directive) {
        directive.setParentNode(this.stack.getLastDirective());
        this.stack.getLastDirective().addChildDirective(directive);
        this.stack.addDirective(directive);
    }

    private List<File> getIncludeFiles(String foundInclude) {
        ArrayList<File> ret = new ArrayList<File>();
        File serverRootFile = new File(this.serverRootPath);
        File check = new File(foundInclude);
        if (check.isAbsolute()) {
            ret.add(check);
        } else {
            for (File f : Glob.match((File)serverRootFile, (String)foundInclude)) {
                ret.add(f);
            }
        }
        return ret;
    }
}

