/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;

public class ApacheVirtualHostServiceDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheServerComponent>,
ResourceUpgradeFacet<ApacheServerComponent> {
    private static final String COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS = "*** Could not determine the virtual host address ***";
    public static final String LOGS_DIRECTORY_NAME = "logs";
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private static final Log log = LogFactory.getLog(ApacheVirtualHostServiceDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        ApacheServerComponent serverComponent = (ApacheServerComponent)context.getParentResourceComponent();
        ApacheDirectiveTree tree = serverComponent.loadParser();
        this.discoverMainServer(context, discoveredResources);
        ResourceType resourceType = context.getResourceType();
        File configPath = serverComponent.getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        for (VHostSpec vhost : VHostSpec.detect(tree)) {
            String resourceKey;
            String firstAddress = vhost.hosts.get(0);
            String resourceName = resourceKey = ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost.serverName, vhost.hosts);
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            HttpdAddressUtility.Address address = serverComponent.getAddressUtility().getVirtualHostSampleAddress(tree, firstAddress, vhost.serverName, false);
            if (address != null) {
                HttpdAddressUtility.Address serverAddress;
                String scheme = address.scheme;
                String hostToPing = address.host;
                int portToPing = address.port;
                if (address.isPortWildcard() || !address.isPortDefined()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, hostToPing, 0);
                    portToPing = serverAddress != null ? serverAddress.port : 0;
                }
                if (address.isHostDefault() || address.isHostWildcard()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, null, portToPing);
                    hostToPing = serverAddress != null ? serverAddress.host : null;
                }
                String url = hostToPing != null && portToPing != 0 && portToPing != -1 ? scheme + "://" + hostToPing + ":" + portToPing + "/" : COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS;
                PropertySimple urlProp = new PropertySimple("url", (Object)url);
                pluginConfiguration.put((Property)urlProp);
                File rtLogFile = new File(logsDir, address.host + address.port + RT_LOG_FILE_NAME_SUFFIX);
                PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
                pluginConfiguration.put((Property)rtLogProp);
                resourceName = address.toString(false);
            }
            discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, pluginConfiguration, null));
        }
        return discoveredResources;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<ApacheServerComponent> inventoriedResource) {
        String resourceKey = inventoriedResource.getResourceKey();
        if ("MainServer".equals(resourceKey) || resourceKey.contains("|")) {
            return null;
        }
        String newResourceKey = null;
        ApacheServerComponent serverComponent = (ApacheServerComponent)inventoriedResource.getParentResourceComponent();
        ApacheDirectiveTree tree = serverComponent.loadParser();
        List<VHostSpec> vhosts = VHostSpec.detect(tree);
        SnmpWwwServiceIndexes snmpIndexes = ApacheVirtualHostServiceDiscoveryComponent.getSnmpDiscoveries(serverComponent, inventoriedResource.getParentResourceContext().getResourceKey());
        for (VHostSpec vhost : vhosts) {
            String legacyResourceKey = ApacheVirtualHostServiceDiscoveryComponent.createLegacyResourceKey(serverComponent, vhost.serverName, vhost.hosts, snmpIndexes);
            if (!resourceKey.equals(legacyResourceKey)) continue;
            newResourceKey = ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost.serverName, vhost.hosts);
            break;
        }
        if (newResourceKey == null) {
            String serverUrl = serverComponent.getServerUrl();
            HttpdAddressUtility.Address serverAddress = HttpdAddressUtility.Address.parse(serverUrl);
            HttpdAddressUtility.Address vhostAddress = HttpdAddressUtility.Address.parse(resourceKey);
            if (ApacheVirtualHostServiceComponent.matchRate(Collections.singletonList(serverAddress), vhostAddress) > 0) {
                newResourceKey = "MainServer";
            }
        }
        if (newResourceKey != null) {
            ResourceUpgradeReport report = new ResourceUpgradeReport();
            report.setNewResourceKey(newResourceKey);
            return report;
        }
        return null;
    }

    private void discoverMainServer(ResourceDiscoveryContext<ApacheServerComponent> context, Set<DiscoveredResourceDetails> discoveredResources) throws Exception {
        ResourceType resourceType = context.getResourceType();
        Configuration mainServerPluginConfig = context.getDefaultPluginConfiguration();
        File configPath = ((ApacheServerComponent)context.getParentResourceComponent()).getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        String mainServerUrl = context.getParentResourceContext().getPluginConfiguration().getSimple("url").getStringValue();
        if (mainServerUrl != null && !"null".equals(mainServerUrl)) {
            PropertySimple mainServerUrlProp = new PropertySimple("url", (Object)mainServerUrl);
            mainServerPluginConfig.put((Property)mainServerUrlProp);
            URI mainServerUri = new URI(mainServerUrl);
            String host = mainServerUri.getHost();
            int port = mainServerUri.getPort();
            if (port == -1) {
                port = 80;
            }
            File rtLogFile = new File(logsDir, host + port + RT_LOG_FILE_NAME_SUFFIX);
            PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
            mainServerPluginConfig.put((Property)rtLogProp);
        }
        String key = "MainServer";
        DiscoveredResourceDetails mainServer = new DiscoveredResourceDetails(resourceType, key, "Main", null, null, mainServerPluginConfig, null);
        discoveredResources.add(mainServer);
    }

    public static String createResourceKey(String serverName, List<String> hosts) {
        StringBuilder keyBuilder = new StringBuilder();
        if (serverName != null) {
            keyBuilder.append(serverName);
        }
        keyBuilder.append("|");
        keyBuilder.append(hosts.get(0));
        for (int i = 1; i < hosts.size(); ++i) {
            keyBuilder.append(" ").append(hosts.get(i));
        }
        return keyBuilder.toString();
    }

    private static String createLegacyResourceKey(ApacheServerComponent serverComponent, String serverName, List<String> hosts, SnmpWwwServiceIndexes snmpIndexes) {
        if (snmpIndexes != null) {
            String newStyleResourceKey = ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(serverName, hosts);
            String legacyResourceKey = null;
            int snmpWwwServiceIndex = ApacheVirtualHostServiceComponent.getMatchingWwwServiceIndex(serverComponent, newStyleResourceKey, snmpIndexes.names, snmpIndexes.ports);
            if (snmpWwwServiceIndex > 0) {
                String host = snmpIndexes.names.get(snmpWwwServiceIndex - 1).toString();
                String fullPort = snmpIndexes.ports.get(snmpWwwServiceIndex - 1).toString();
                String port = fullPort.substring(fullPort.lastIndexOf(".") + 1);
                legacyResourceKey = host + ":" + port;
            }
            if (legacyResourceKey != null) {
                return legacyResourceKey;
            }
        }
        String host = hosts.get(0);
        HttpdAddressUtility.Address hostAddr = HttpdAddressUtility.Address.parse(host);
        if (serverName != null) {
            HttpdAddressUtility.Address serverAddr = HttpdAddressUtility.Address.parse(serverName);
            hostAddr.host = serverAddr.host;
        }
        try {
            InetAddress hostName = InetAddress.getByName(hostAddr.host);
            hostAddr.host = hostName.getHostName();
        }
        catch (UnknownHostException e) {
            log.debug((Object)("Host " + hostAddr.host + " is not resolvable."), (Throwable)e);
        }
        return hostAddr.host + ":" + hostAddr.port;
    }

    private static SnmpWwwServiceIndexes getSnmpDiscoveries(ApacheServerComponent serverComponent, String serverResourceKey) {
        try {
            List<SNMPValue> portValues;
            List<SNMPValue> nameValues;
            SNMPSession snmpSession = serverComponent.getSNMPSession();
            try {
                nameValues = snmpSession.getColumn("wwwServiceName");
            }
            catch (SNMPException e) {
                throw new Exception("Error getting SNMP column: wwwServiceName: " + e.getMessage(), e);
            }
            try {
                portValues = snmpSession.getColumn("wwwServiceProtocol");
            }
            catch (SNMPException e) {
                throw new Exception("Error getting SNMP column: wwwServiceProtocol: " + e.getMessage(), e);
            }
            SnmpWwwServiceIndexes ret = new SnmpWwwServiceIndexes();
            ret.names = nameValues;
            ret.ports = portValues;
            return ret;
        }
        catch (Exception e) {
            log.debug((Object)("Error while trying to contact SNMP of the apache server " + serverResourceKey), (Throwable)e);
            return null;
        }
    }

    private static class VHostSpec {
        public String serverName;
        public List<String> hosts;

        public static List<VHostSpec> detect(ApacheDirectiveTree config) {
            List<ApacheDirective> virtualHosts = config.search("/<VirtualHost");
            ArrayList<VHostSpec> ret = new ArrayList<VHostSpec>(virtualHosts.size());
            for (ApacheDirective dir : virtualHosts) {
                ret.add(new VHostSpec(dir));
            }
            return ret;
        }

        public VHostSpec(ApacheDirective vhostDirective) {
            this.hosts = vhostDirective.getValues();
            List<ApacheDirective> serverNames = vhostDirective.getChildByName("ServerName");
            this.serverName = null;
            if (serverNames.size() > 0) {
                this.serverName = serverNames.get(0).getValuesAsString();
            }
        }
    }

    private static class SnmpWwwServiceIndexes {
        public List<SNMPValue> names;
        public List<SNMPValue> ports;

        private SnmpWwwServiceIndexes() {
        }
    }
}

