/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rhq.augeas.node.AugeasNode;

public class AugeasNodeSearch {
    public static String[] NESTED_DIRECTIVES = new String[]{"<IfModule", "<Directive", "<VirtualHost", "<Files"};

    public static List<AugeasNode> searchNode(String[] parentNodeNames, String nodeName, AugeasNode startNode) {
        ArrayList<AugeasNode> nodes = new ArrayList<AugeasNode>();
        AugeasNodeSearch.search(nodes, parentNodeNames, startNode, nodeName);
        return nodes;
    }

    private static void search(List<AugeasNode> nodes, String[] parentNodeNames, AugeasNode node, String name) {
        nodes.addAll(node.getChildByLabel(name));
        for (String parentNodeName : parentNodeNames) {
            List nds = node.getChildByLabel(parentNodeName);
            for (AugeasNode tempNode : nds) {
                AugeasNodeSearch.search(nodes, parentNodeNames, tempNode, name);
            }
        }
    }

    public static List<AugeasNode> getNodeByParentParams(AugeasNode parentNode, String nodeName, List<String> nodeParams) {
        List<AugeasNode> searchedNodes = AugeasNodeSearch.searchNode(NESTED_DIRECTIVES, nodeName, parentNode);
        ArrayList<AugeasNode> results = new ArrayList<AugeasNode>();
        Iterator<AugeasNode> i$ = searchedNodes.iterator();
        while (i$.hasNext()) {
            AugeasNode node;
            AugeasNode tempNode = node = i$.next();
            boolean match = true;
            int i = 0;
            while (match & i < nodeParams.size() & tempNode != parentNode) {
                List childNodes = tempNode.getChildByLabel("param");
                if (childNodes.size() > 0) {
                    if (!nodeParams.get(i).equals(((AugeasNode)childNodes.get(0)).getValue())) {
                        match = false;
                    }
                } else {
                    match = false;
                }
                ++i;
                tempNode = tempNode.getParentNode();
            }
            if (!match) continue;
            results.add(node);
        }
        return results;
    }

    public static List<String> getParams(AugeasNode node, AugeasNode parentNode) {
        ArrayList<String> res = new ArrayList<String>();
        AugeasNode pNode = node;
        while (!pNode.equals(parentNode)) {
            List paramNodes = pNode.getChildByLabel("param");
            for (AugeasNode param : paramNodes) {
                res.add(param.getValue());
            }
            pNode = pNode.getParentNode();
        }
        return res;
    }

    public static String getNodeParamString(AugeasNode nd) {
        List childNodes = nd.getChildByLabel("param");
        StringBuilder str = new StringBuilder();
        for (AugeasNode paramNode : childNodes) {
            str.append(paramNode.getValue());
        }
        return str.toString();
    }

    public static int getNodeIndex(AugeasNode node) {
        List nodes = node.getParentNode().getChildByLabel(node.getLabel());
        String param = AugeasNodeSearch.getNodeParamString(node);
        int index = 1;
        for (AugeasNode nd : nodes) {
            if (!AugeasNodeSearch.getNodeParamString(nd).equals(param)) continue;
            if (node.equals(nd)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public static String getNodeKeyFromParent(AugeasNode node) {
        String param = AugeasNodeSearch.getNodeParamString(node);
        int index = AugeasNodeSearch.getNodeIndex(node);
        return node.getLabel() + "|" + param + "|" + String.valueOf(index) + ";";
    }

    public static String getNodeKey(AugeasNode node, AugeasNode parentNode) {
        AugeasNode pNode = node;
        StringBuilder str = new StringBuilder();
        while (pNode != null & !pNode.equals(parentNode)) {
            str.append(AugeasNodeSearch.getNodeKeyFromParent(pNode));
            pNode = pNode.getParentNode();
        }
        return str.toString();
    }

    public static AugeasNode findNodeById(AugeasNode parentNode, String params) {
        AugeasNode tempNode = parentNode;
        String[] ids = params.split(";");
        for (int i = ids.length - 1; i >= 0; --i) {
            tempNode = AugeasNodeSearch.getNodeFromParentById(tempNode, ids[i]);
        }
        return tempNode;
    }

    public static AugeasNode getNodeFromParentById(AugeasNode parentNode, String params) {
        int index = 1;
        String[] paramsArray = params.split("\\|");
        if (paramsArray.length != 3) {
            throw new RuntimeException("Node with id " + params + " was not found.");
        }
        String nodeName = paramsArray[0];
        String parameters = paramsArray[1];
        index = Integer.valueOf(paramsArray[2]);
        for (AugeasNode nd : parentNode.getChildByLabel(nodeName)) {
            String ndParam = AugeasNodeSearch.getNodeKeyFromParent(nd);
            if (!ndParam.equals(params + ";")) continue;
            return nd;
        }
        throw new RuntimeException("Searched node with id " + params + " was not found.");
    }
}

