/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.util.StringUtil;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;

public class ApacheDirectoryDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheVirtualHostServiceComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheVirtualHostServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        ApacheDirective vhost = ((ApacheVirtualHostServiceComponent)context.getParentResourceComponent()).getDirective(true);
        return this.discoverResources(context, discoveredResources, vhost, "");
    }

    private Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheVirtualHostServiceComponent> context, Set<DiscoveredResourceDetails> discoveredResources, ApacheDirective parent, String parentKey) {
        HashMap<String, Integer> ifModuleIndex = new HashMap<String, Integer>();
        for (ApacheDirective directive : parent.getChildDirectives()) {
            if (directive.getName().startsWith("<Directory")) {
                boolean isRegexp;
                String directoryParam;
                ResourceType resourceType = context.getResourceType();
                List<String> params = directive.getValues();
                if (params.size() > 1 && StringUtil.isNotBlank((String)params.get(1))) {
                    directoryParam = params.get(1);
                    isRegexp = true;
                } else {
                    directoryParam = params.get(0);
                    isRegexp = false;
                }
                Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
                pluginConfiguration.put((Property)new PropertySimple("regexp", (Object)isRegexp));
                String resourceName = AugeasNodeValueUtil.unescape(directoryParam);
                int index = 1;
                for (DiscoveredResourceDetails detail : discoveredResources) {
                    if (!detail.getResourceName().equals(resourceName)) continue;
                    ++index;
                }
                String resourceKey = directive.getName() + "|" + directoryParam + "|" + index + ";" + parentKey;
                discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, pluginConfiguration, null));
                continue;
            }
            if (!directive.isConditional()) continue;
            int index = 1;
            String moduleName = directive.getValues().get(0);
            if (ifModuleIndex.containsKey(moduleName)) {
                index = (Integer)ifModuleIndex.get(moduleName) + 1;
            }
            ifModuleIndex.put(moduleName, index);
            String ifModuleKey = directive.getName() + "|" + moduleName + "|" + index + ";" + parentKey;
            LinkedHashSet<DiscoveredResourceDetails> discoveredSubResources = new LinkedHashSet<DiscoveredResourceDetails>();
            this.discoverResources(context, discoveredSubResources, directive, ifModuleKey);
            discoveredResources.addAll(discoveredSubResources);
        }
        return discoveredResources;
    }
}

