/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.rhq.augeas.util.Glob;
import org.rhq.plugins.apache.parser.ApacheConfigReader;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveStack;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.parser.ApacheParser;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;
import org.rhq.plugins.apache.util.RuntimeApacheConfiguration;

public class ApacheParserImpl
implements ApacheParser {
    private static final String INCLUDE_DIRECTIVE = "Include";
    private static final String INCLUDEOPTIONAL_DIRECTIVE = "IncludeOptional";
    private static final String SERVER_ROOT_DIRECTIVE = "ServerRoot";
    private final ApacheDirectiveTree tree;
    private ApacheDirectiveStack stack = new ApacheDirectiveStack();
    private String serverRootPath;
    private RuntimeApacheConfiguration.NodeInspector nodeInspector;

    public ApacheParserImpl(ApacheDirectiveTree tree, String initialServerRootPath, RuntimeApacheConfiguration.NodeInspector nodeInspector) {
        this.serverRootPath = initialServerRootPath;
        this.tree = tree;
        this.stack.addDirective(this.tree.getRootNode());
        this.nodeInspector = nodeInspector;
    }

    @Override
    public void addDirective(ApacheDirective directive) throws Exception {
        if (this.stack.getLastDirective() == null) {
            return;
        }
        String directiveName = directive.getName();
        if (directiveName.equals(INCLUDE_DIRECTIVE) || directiveName.equals(INCLUDEOPTIONAL_DIRECTIVE)) {
            List<File> files = this.getIncludeFiles(directive.getValuesAsString());
            for (File fl : files) {
                if (!fl.exists() || !fl.isFile()) continue;
                ApacheConfigReader.searchFile(fl.getAbsolutePath(), this);
            }
        } else if (directiveName.equals(SERVER_ROOT_DIRECTIVE)) {
            this.serverRootPath = AugeasNodeValueUtil.unescape(directive.getValuesAsString());
        }
        if (this.nodeInspector != null) {
            this.nodeInspector.inspect(directiveName, directive.getValues(), directive.getValuesAsString());
        }
        directive.setParentNode(this.stack.getLastDirective());
        this.stack.getLastDirective().addChildDirective(directive);
    }

    @Override
    public void endNestedDirective(ApacheDirective directive) {
        this.stack.removeLastDirective();
    }

    @Override
    public void startNestedDirective(ApacheDirective directive) {
        if (this.nodeInspector != null) {
            RuntimeApacheConfiguration.NodeInspectionResult res = this.nodeInspector.inspect(directive.getName(), directive.getValues(), directive.getValuesAsString());
            if (res == null || res.nodeIsConditional && !res.shouldRecurseIntoConditionalNode) {
                this.stack.addDirective(null);
            } else if (res.nodeIsConditional && res.shouldRecurseIntoConditionalNode) {
                if (!this.nodeInspector.keepConditional) {
                    this.stack.addDirective(this.stack.getLastDirective());
                } else {
                    if (this.stack.getLastDirective() != null) {
                        directive.setParentNode(this.stack.getLastDirective());
                        this.stack.getLastDirective().addChildDirective(directive);
                    }
                    this.stack.addDirective(directive);
                }
            } else {
                if (this.stack.getLastDirective() != null) {
                    directive.setParentNode(this.stack.getLastDirective());
                    this.stack.getLastDirective().addChildDirective(directive);
                }
                this.stack.addDirective(directive);
            }
        } else {
            if (this.stack.getLastDirective() != null) {
                directive.setParentNode(this.stack.getLastDirective());
                this.stack.getLastDirective().addChildDirective(directive);
            }
            this.stack.addDirective(directive);
        }
    }

    private List<File> getIncludeFiles(String foundInclude) {
        File check = new File(foundInclude);
        File root = new File(check.isAbsolute() ? Glob.rootPortion((String)foundInclude) : this.serverRootPath);
        return Glob.match((File)root, (String)foundInclude, (Comparator)Glob.ALPHABETICAL_COMPARATOR);
    }
}

