/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.parser;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.rhq.augeas.util.Glob;
import org.rhq.plugins.apache.parser.ApacheConfigReader;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveStack;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.parser.ApacheParser;

public class ApacheParserImpl
implements ApacheParser {
    private static final String INCLUDE_DIRECTIVE = "Include";
    private final ApacheDirectiveTree tree;
    private ApacheDirectiveStack stack = new ApacheDirectiveStack();
    private String serverRootPath;

    public ApacheParserImpl(ApacheDirectiveTree tree, String serverRootPath) {
        this.serverRootPath = serverRootPath;
        this.tree = tree;
        this.stack.addDirective(this.tree.getRootNode());
    }

    @Override
    public void addDirective(ApacheDirective directive) throws Exception {
        if (directive.getName().equals(INCLUDE_DIRECTIVE)) {
            List<File> files = this.getIncludeFiles(directive.getValuesAsString());
            for (File fl : files) {
                if (!fl.exists() || !fl.isFile()) continue;
                ApacheConfigReader.searchFile(fl.getAbsolutePath(), this);
            }
        }
        directive.setParentNode(this.stack.getLastDirective());
        this.stack.getLastDirective().addChildDirective(directive);
    }

    @Override
    public void endNestedDirective(ApacheDirective directive) {
        this.stack.removeLastDirective();
    }

    @Override
    public void startNestedDirective(ApacheDirective directive) {
        directive.setParentNode(this.stack.getLastDirective());
        this.stack.getLastDirective().addChildDirective(directive);
        this.stack.addDirective(directive);
    }

    private List<File> getIncludeFiles(String foundInclude) {
        File check = new File(foundInclude);
        File root = new File(check.isAbsolute() ? Glob.rootPortion((String)foundInclude) : this.serverRootPath);
        return Glob.match((File)root, (String)foundInclude, (Comparator)Glob.ALPHABETICAL_COMPARATOR);
    }
}

