/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.www.snmp;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.www.snmp.MIBLookupException;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPSessionCache;
import org.rhq.plugins.www.snmp.SNMPSession_v1;
import org.rhq.plugins.www.snmp.SNMPSession_v2c;
import org.rhq.plugins.www.snmp.SNMPSession_v3;
import org.snmp4j.smi.OID;

public class SNMPClient {
    static final int AUTH_MD5 = 0;
    static final int AUTH_SHA = 1;
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 161;
    public static final String DEFAULT_COMMUNITY = "public";
    public static final String DEFAULT_USERNAME = "username";
    public static final String DEFAULT_PASSWORD = "password";
    public static final SNMPVersion DEFAULT_VERSION = SNMPVersion.V2C;
    public static final String[] VALID_AUTHTYPES = new String[]{"md5", "sha"};
    private static Log log = LogFactory.getLog(SNMPClient.class);
    private static int CACHE_EXPIRE_DEFAULT = 60000;
    private static final Map<String, OID> MIB_OID_CACHE = new HashMap<String, OID>();
    private static final Map<Integer, SNMPSession> SESSION_CACHE = new HashMap<Integer, SNMPSession>();
    private static final Properties OIDS = new Properties();
    private int sessionCacheExpire = CACHE_EXPIRE_DEFAULT;
    private static final int SESSION_TIMEOUT = 500;
    private static final int SESSION_RETRIES = 1;
    private static final String OIDS_PROPERTIES_RESOURCE_PATH = "org/rhq/plugins/apache/oids.properties";

    public SNMPClient() {
        if (OIDS.isEmpty()) {
            this.initOids();
        }
    }

    private static int parseAuthMethod(String authMethod) {
        if (authMethod == null) {
            throw new IllegalArgumentException("authMethod is null");
        }
        if (authMethod.equalsIgnoreCase("md5")) {
            return 0;
        }
        if (authMethod.equalsIgnoreCase("sha")) {
            return 1;
        }
        throw new IllegalArgumentException("unknown authMethod: " + authMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOids() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = contextClassLoader != null ? contextClassLoader : this.getClass().getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(OIDS_PROPERTIES_RESOURCE_PATH);
        if (stream == null) {
            throw new IllegalStateException("Resource 'org/rhq/plugins/apache/oids.properties' not found by " + classLoader);
        }
        Properties props = new Properties();
        try {
            try {
                props.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to parse oids.properties file from plugin classloader.", e);
        }
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            OIDS.setProperty(propName, props.getProperty(propName).trim());
        }
    }

    static synchronized OID getMibOID(String mibName) throws MIBLookupException {
        if (mibName.charAt(0) == '.') {
            mibName = mibName.substring(1);
        }
        if (Character.isDigit(mibName.charAt(0))) {
            return new OID(mibName);
        }
        OID oid = MIB_OID_CACHE.get(mibName);
        if (oid == null) {
            String oidString = OIDS.getProperty(mibName);
            if (oidString == null) {
                String msg = "Failed to lookup OID for name=" + mibName;
                throw new MIBLookupException(msg);
            }
            oid = new OID(oidString);
            if (oid.size() == 0) {
                throw new IllegalStateException("Failed to parse OID string [" + oidString + "] while mapping MIB name [" + mibName + "].");
            }
            log.debug((Object)("MIB name [" + mibName + "] mapped to OID [" + oid + "]."));
            MIB_OID_CACHE.put(mibName, oid);
        }
        return oid;
    }

    public static String getOID(String mibName) {
        try {
            return SNMPClient.getMibOID(mibName).toString();
        }
        catch (MIBLookupException e) {
            return null;
        }
    }

    static SNMPSession startSession(SNMPVersion version) throws SNMPException {
        switch (version) {
            case V1: {
                return new SNMPSession_v1();
            }
            case V2C: {
                return new SNMPSession_v2c();
            }
            case V3: {
                return new SNMPSession_v3();
            }
        }
        throw new SNMPException("Invalid SNMP Version: " + (Object)((Object)version));
    }

    public boolean init(Properties props) throws SNMPException {
        String prop = "snmp.sessionCacheExpire";
        String expire = props.getProperty("snmp.sessionCacheExpire");
        if (expire != null) {
            this.sessionCacheExpire = Integer.parseInt(expire) * 1000;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<Integer, SNMPSession> map = SESSION_CACHE;
        synchronized (map) {
            Collection<SNMPSession> sessions = SESSION_CACHE.values();
            for (SNMPSession session : sessions) {
                session.close();
            }
            SESSION_CACHE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SNMPSession getSession(String host, Integer port, String community, SNMPVersion version) throws SNMPException {
        InetAddress ip;
        SNMPSession session;
        if (host == null) {
            host = DEFAULT_HOST;
        }
        if (port == null) {
            port = 161;
        }
        if (community == null) {
            community = DEFAULT_COMMUNITY;
        }
        if (version == null) {
            version = DEFAULT_VERSION;
        }
        int id = host.hashCode() ^ port.hashCode() ^ community.hashCode() ^ version.hashCode();
        Map<Integer, SNMPSession> map = SESSION_CACHE;
        synchronized (map) {
            session = SESSION_CACHE.get(id);
        }
        if (session != null) {
            return session;
        }
        try {
            ip = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new SNMPException("Invalid Host: '" + host + "': " + e);
        }
        if (port < 1 || port > 65535) {
            throw new SNMPException("Invalid Port: " + port);
        }
        if (!community.trim().equals(community)) {
            throw new SNMPException("Invalid Community: '" + community + "': whitespace is not permitted");
        }
        try {
            session = SNMPClient.startSession(version);
            switch (version) {
                case V1: 
                case V2C: {
                    ((SNMPSession_v1)session).init(host, port, community);
                    break;
                }
                case V3: {
                    String user = "TODO";
                    String pass = "TODO";
                    int authType = SNMPClient.parseAuthMethod("TODO");
                    ((SNMPSession_v3)session).init(host, port, user, pass, authType);
                    break;
                }
                default: {
                    throw new SNMPException("unsupported SNMP version");
                }
            }
            session.setTimeout(500L);
            session.setRetries(1);
            log.info((Object)("Initialized SNMP session for agent at " + ip + ":" + port));
        }
        catch (SNMPException e) {
            String msg = "Failed to initialize snmp session";
            throw new SNMPException(msg, e);
        }
        session = SNMPSessionCache.newInstance(session, this.sessionCacheExpire);
        Map<Integer, SNMPSession> map2 = SESSION_CACHE;
        synchronized (map2) {
            SESSION_CACHE.put(id, session);
        }
        return session;
    }

    public static enum SNMPVersion {
        V1,
        V2C,
        V3;

    }
}

