/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.util.ArrayList;
import java.util.List;
import org.rhq.plugins.apache.ApacheVirtualHostServiceDiscoveryComponent;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;

public class VHostSpec {
    public String serverName;
    public List<String> hosts;

    public static List<VHostSpec> detect(ApacheDirectiveTree config) {
        List<ApacheDirective> virtualHosts = config.search("/<VirtualHost");
        ArrayList<VHostSpec> ret = new ArrayList<VHostSpec>(virtualHosts.size());
        for (ApacheDirective dir : virtualHosts) {
            ret.add(new VHostSpec(dir));
        }
        return ret;
    }

    public VHostSpec() {
    }

    public VHostSpec(ApacheDirective vhostDirective) {
        this.hosts = new ArrayList<String>(vhostDirective.getValues());
        List<ApacheDirective> serverNames = vhostDirective.getChildByName("ServerName");
        this.serverName = null;
        if (serverNames.size() > 0) {
            this.serverName = serverNames.get(serverNames.size() - 1).getValuesAsString();
        }
    }

    public String toString() {
        return ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(this.serverName, this.hosts);
    }

    public int hashCode() {
        int ret = this.serverName != null ? this.serverName.hashCode() : 1;
        for (String host : this.hosts) {
            ret = 31 * ret * host.hashCode();
        }
        return ret;
    }

    public boolean equals(Object o) {
        boolean serverNameEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof VHostSpec)) {
            return false;
        }
        VHostSpec other = (VHostSpec)o;
        boolean bl = this.serverName == null ? other.serverName == null : (serverNameEqual = this.serverName.equals(other.serverName));
        if (!serverNameEqual) {
            return false;
        }
        return ((Object)this.hosts).equals(other.hosts);
    }
}

