/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.www.snmp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.plugins.www.snmp.MIBLookupException;
import org.rhq.plugins.www.snmp.SNMPClient;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPTimeoutException;
import org.rhq.plugins.www.snmp.SNMPValue;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

class SNMPSession_v1
implements SNMPSession {
    protected static Snmp session;
    protected int version = 0;
    protected CommunityTarget target;
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String ANY_LOCAL_ADDRESS = "0.0.0.0";
    private static final int ANY_FREE_PORT = 0;
    private static final int GETBULK_MAX_REPETITIONS = 10;
    private static final int GETBULK_NON_REPEATERS = 0;
    private static final String PING_OID = "1";
    private static final String PING_MIB_NAME = "iso";

    SNMPSession_v1() {
    }

    void init(String host, int port, String community, long timeout, int retries) throws SNMPException {
        if (session == null) {
            session = this.initSession();
        }
        Address address = GenericAddress.parse((String)("udp:" + host + "/" + port));
        this.target = new CommunityTarget();
        this.target.setAddress(address);
        this.target.setCommunity(new OctetString(community));
        this.target.setVersion(this.version);
        this.target.setRetries(retries);
        this.target.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to close the SNMP session. Cause: " + e));
            }
            finally {
                session = null;
            }
        }
    }

    @Override
    @NotNull
    public SNMPValue getSingleValue(String name) throws SNMPException {
        return this.getValue(name, -96);
    }

    @Override
    @NotNull
    public SNMPValue getNextValue(String name) throws SNMPException {
        return this.getValue(name, -95);
    }

    @Override
    @NotNull
    public List<SNMPValue> getColumn(String mibName) throws SNMPException {
        ArrayList<SNMPValue> values = new ArrayList<SNMPValue>();
        OID oid = SNMPClient.getMibOID(mibName);
        TreeUtils treeUtils = new TreeUtils((Session)session, (PDUFactory)new DefaultPDUFactory());
        treeUtils.setMaxRepetitions(10);
        List events = treeUtils.getSubtree((Target)this.target, oid);
        for (TreeEvent event : events) {
            if (event.isError()) {
                throw new SNMPException("Error occurred while retrieving column " + mibName + "(" + oid + "): " + event.getErrorMessage(), event.getException());
            }
            VariableBinding[] varBindings = event.getVariableBindings();
            if (varBindings == null) continue;
            for (VariableBinding varBinding : varBindings) {
                values.add(new SNMPValue(varBinding));
            }
        }
        return values;
    }

    @Override
    @NotNull
    public Map<String, SNMPValue> getTable(String mibName, int index) throws SNMPException {
        LinkedHashMap<String, SNMPValue> map = new LinkedHashMap<String, SNMPValue>();
        OID rootOid = new OID(SNMPClient.getMibOID(mibName));
        rootOid.append(index);
        List<SNMPValue> values = this.getColumn(rootOid.toString());
        for (SNMPValue value : values) {
            OID leafOid = new OID(value.getOID());
            OID suffixOid = new OID(leafOid.getValue(), rootOid.size(), leafOid.size() - rootOid.size());
            map.put(suffixOid.toString(), value);
        }
        return map;
    }

    @Override
    @NotNull
    public List<SNMPValue> getBulk(String mibName) throws SNMPException {
        ArrayList<SNMPValue> values = new ArrayList<SNMPValue>();
        PDU request = this.createPDU(mibName, -91);
        request.setMaxRepetitions(10);
        request.setNonRepeaters(0);
        PDU response = this.sendRequest(request, mibName);
        Vector varBindings = response.getVariableBindings();
        for (VariableBinding varBinding : varBindings) {
            values.add(new SNMPValue(varBinding));
        }
        return values;
    }

    @Override
    public boolean ping() {
        boolean errorOccurred;
        PDU response;
        try {
            PDU pdu = this.createPDU(PING_OID, -95);
            response = this.sendRequest(pdu, PING_MIB_NAME);
        }
        catch (SNMPException e) {
            if (e instanceof SNMPTimeoutException) {
                long timeoutMillis = this.target.getTimeout() * (long)(this.target.getRetries() + 1);
                this.log.debug((Object)("Timed out after " + timeoutMillis + " while pinging " + this.version + " agent at " + this + "."));
            } else {
                this.log.debug((Object)("Error while pinging SNMP " + this.version + " agent at " + this + ". SNMP GETNEXT request for iso(1) failed: " + e));
            }
            return false;
        }
        boolean bl = errorOccurred = response.getErrorStatus() != 0;
        if (errorOccurred) {
            this.log.error((Object)("Error while pinging SNMP " + this.version + " agent at " + this + ". SNMP GETNEXT request for iso(1) failed: " + response.getErrorStatusText()));
        }
        return !errorOccurred;
    }

    public String toString() {
        return this.target.getAddress() + "/" + this.target.getCommunity();
    }

    protected PDU createPDU(String mibName, int type) throws MIBLookupException {
        PDU pdu = new DefaultPDUFactory().createPDU((Target)this.target);
        pdu.setType(type);
        OID oid = SNMPClient.getMibOID(mibName);
        pdu.add(new VariableBinding(oid));
        return pdu;
    }

    private Snmp initSession() throws SNMPException {
        try {
            InetAddress host = InetAddress.getByName(ANY_LOCAL_ADDRESS);
            int port = 0;
            UdpAddress addr = new UdpAddress(host, port);
            session = new Snmp((TransportMapping)new DefaultUdpTransportMapping(addr));
            session.listen();
        }
        catch (IOException e) {
            throw new SNMPException("Failed to initialize SNMP session.", e);
        }
        return session;
    }

    private SNMPValue getValue(String mibName, int pduType) throws SNMPException {
        PDU request = this.createPDU(mibName, pduType);
        PDU response = this.sendRequest(request, mibName);
        return new SNMPValue(response.get(0));
    }

    @NotNull
    private PDU sendRequest(PDU request, String mibName) throws SNMPException {
        ResponseEvent responseEvent;
        String requestType = PDU.getTypeString((int)request.getType());
        try {
            responseEvent = session.send(request, (Target)this.target);
        }
        catch (IOException e) {
            throw new SNMPException("Failed to send " + requestType + " request for [" + mibName + "]", e);
        }
        if (responseEvent == null) {
            throw new SNMPException("No response to " + requestType + " request for [" + mibName + "].");
        }
        PDU response = responseEvent.getResponse();
        if (response == null) {
            throw new SNMPTimeoutException(requestType + " request for [" + mibName + "] timed out.");
        }
        return response;
    }
}

