/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.AugeasComponent;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.util.AugeasNodeSearch;

public class ApacheDirectoryComponent
implements ResourceComponent<ApacheVirtualHostServiceComponent>,
ConfigurationFacet,
DeleteResourceFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String REGEXP_PROP = "regexp";
    public static final String DIRECTORY_DIRECTIVE = "<Directory";
    private ResourceContext<ApacheVirtualHostServiceComponent> resourceContext;

    public void start(ResourceContext<ApacheVirtualHostServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        if (!this.isAugeasEnabled()) {
            throw new IllegalStateException("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform.");
        }
        AugeasComponent comp = this.getAugeas();
        try {
            AugeasTree tree = comp.getAugeasTree("Httpd");
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            Configuration configuration = mapping.updateConfiguration(this.getNode(tree), resourceConfigDef);
            return configuration;
        }
        finally {
            comp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        if (!this.isAugeasEnabled()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform.");
            return;
        }
        AugeasComponent comp = this.getAugeas();
        AugeasTree tree = null;
        try {
            tree = comp.getAugeasTree("Httpd");
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            AugeasNode directoryNode = this.getNode(tree);
            mapping.updateAugeas(directoryNode, report.getConfiguration(), resourceConfigDef);
            tree.save();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            this.log.info((Object)"Apache configuration was updated");
            ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                this.log.error((Object)("Augeas failed to save configuration " + tree.summarizeAugeasError()), (Throwable)e);
            } else {
                this.log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage("Augeas failed to save the configuration. " + ThrowableUtil.getStackAsString((Throwable)e));
        }
        finally {
            comp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        if (!this.isAugeasEnabled()) {
            throw new IllegalStateException("Configuration and child resource creation/deletion support for Apache is optional. If you switched it on by enabling Augeas support in the connection settings of the Apache server resource and still get this message, it means that either your Apache version is not supported (only Apache 2.x is supported) or Augeas is not available on your platform.");
        }
        AugeasComponent comp = this.getAugeas();
        try {
            AugeasTree tree = comp.getAugeasTree("Httpd");
            AugeasNode myNode = this.getNode(tree);
            if (myNode != null) {
                tree.removeNode(myNode, true);
                tree.save();
                ApacheVirtualHostServiceComponent parentVhost = (ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent();
                parentVhost.deleteEmptyFile(tree, myNode);
                parentVhost.conditionalRestart();
            } else {
                this.log.info((Object)("Could find the configuration corresponding to the directory " + this.resourceContext.getResourceKey() + ". Ignoring."));
            }
        }
        finally {
            comp.close();
        }
    }

    @Deprecated
    public AugeasNode getNode(AugeasNode virtualHost) {
        AugeasNode directory = AugeasNodeSearch.findNodeById(virtualHost, this.resourceContext.getResourceKey());
        return directory;
    }

    public AugeasNode getNode(AugeasTree tree) {
        AugeasNode virtHostNode = ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).getNode(tree);
        return AugeasNodeSearch.findNodeById(virtHostNode, this.resourceContext.getResourceKey());
    }

    public AugeasComponent getAugeas() {
        return ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).getAugeas();
    }

    public void finishConfigurationUpdate(ConfigurationUpdateReport report) {
        ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).finishConfigurationUpdate(report);
    }

    public boolean isAugeasEnabled() {
        ApacheVirtualHostServiceComponent parent = (ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent();
        return parent.isAugeasEnabled();
    }
}

