/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.apache.util.VHostSpec;
import org.rhq.plugins.apache.util.VirtualHostLegacyResourceKeyUtil;

public class ApacheVirtualHostServiceDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheServerComponent>,
ResourceUpgradeFacet<ApacheServerComponent> {
    private static final String COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS = "*** Could not determine the virtual host address ***";
    public static final String LOGS_DIRECTORY_NAME = "logs";
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private static final String LEGACY_SNMP_SERVICE_INDEX_CONFIG_PROP = "snmpWwwServiceIndex";
    private static final Log log = LogFactory.getLog(ApacheVirtualHostServiceDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        ApacheServerComponent serverComponent = (ApacheServerComponent)context.getParentResourceComponent();
        ApacheDirectiveTree tree = serverComponent.parseRuntimeConfiguration(false);
        this.discoverMainServer(context, tree, discoveredResources);
        ResourceType resourceType = context.getResourceType();
        File configPath = serverComponent.getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        for (VHostSpec vhost : VHostSpec.detect(tree)) {
            String resourceKey;
            String firstAddress = vhost.hosts.get(0);
            String resourceName = resourceKey = ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost.serverName, vhost.hosts);
            Configuration pluginConfiguration = context.getDefaultPluginConfiguration();
            HttpdAddressUtility.Address address = serverComponent.getAddressUtility().getVirtualHostSampleAddress(tree, firstAddress, vhost.serverName, false);
            if (address != null) {
                HttpdAddressUtility.Address serverAddress;
                String scheme = address.scheme;
                String hostToPing = address.host;
                int portToPing = address.port;
                if (address.isPortWildcard() || !address.isPortDefined()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, hostToPing, 0);
                    portToPing = serverAddress != null ? serverAddress.port : 0;
                }
                if (address.isHostDefault() || address.isHostWildcard()) {
                    serverAddress = serverComponent.getAddressUtility().getMainServerSampleAddress(tree, null, portToPing);
                    hostToPing = serverAddress != null ? serverAddress.host : null;
                }
                String url = hostToPing != null && portToPing != 0 && portToPing != -1 ? scheme + "://" + hostToPing + ":" + portToPing + "/" : COULD_NOT_DETERMINE_THE_VIRTUAL_HOST_ADDRESS;
                PropertySimple urlProp = new PropertySimple("url", (Object)url);
                pluginConfiguration.put((Property)urlProp);
                File rtLogFile = new File(logsDir, address.host + address.port + RT_LOG_FILE_NAME_SUFFIX);
                PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
                pluginConfiguration.put((Property)rtLogProp);
                resourceName = address.toString(false, true);
            }
            discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, pluginConfiguration, null));
        }
        return discoveredResources;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<ApacheServerComponent> inventoriedResource) {
        VHostSpec vhost3;
        String resourceKey = inventoriedResource.getResourceKey();
        if ("MainServer".equals(resourceKey) || resourceKey.contains("|")) {
            return null;
        }
        String newResourceKey = null;
        ApacheServerComponent serverComponent = (ApacheServerComponent)inventoriedResource.getParentResourceComponent();
        ApacheDirectiveTree tree = serverComponent.parseRuntimeConfiguration(false);
        List<VHostSpec> vhosts = VHostSpec.detect(tree);
        VirtualHostLegacyResourceKeyUtil legacyResourceKeyUtil = new VirtualHostLegacyResourceKeyUtil(serverComponent, tree);
        String snmpServiceIndexString = inventoriedResource.getPluginConfiguration().getSimpleValue(LEGACY_SNMP_SERVICE_INDEX_CONFIG_PROP, null);
        if (snmpServiceIndexString != null) {
            Integer snmpServiceIndex = null;
            try {
                snmpServiceIndex = Integer.parseInt(snmpServiceIndexString);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid format of the snmpWwwServiceIndex property value. It should be an integer but is '" + snmpServiceIndexString + "'. The upgrade will continue using the resource key matching."), (Throwable)e);
            }
            if (snmpServiceIndex != null) {
                if (snmpServiceIndex > 0) {
                    if (snmpServiceIndex == 1) {
                        Set<String> legacyResourceKeys = legacyResourceKeyUtil.getLegacyMainServerResourceKeys();
                        if (legacyResourceKeys.contains(resourceKey)) {
                            newResourceKey = "MainServer";
                        } else {
                            log.debug((Object)("The cross-check of the SNMP WWW Service Index value and resource key failed for virtual host with old resource key: " + resourceKey + ". The upgrade will continue using resource key matching."));
                        }
                    } else if (vhosts.size() + 1 < snmpServiceIndex) {
                        log.debug((Object)("The snmpWwwServiceIndex property contains incorrect value (" + snmpServiceIndex + "), which is larger than the total number of active virtual hosts in the configuration files (" + (vhosts.size() + 1) + ". The upgrade will continue using the resource key matching."));
                    } else {
                        VHostSpec vhost2 = vhosts.get(vhosts.size() - snmpServiceIndex + 1);
                        Set<String> legacyResourceKeys = legacyResourceKeyUtil.getLegacyVirtualHostResourceKeys(vhost2);
                        if (legacyResourceKeys.contains(resourceKey)) {
                            newResourceKey = ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost2.serverName, vhost2.hosts);
                        } else {
                            log.debug((Object)("The cross-check of the SNMP WWW Service Index value and resource key failed for virtual host with old resource key: " + resourceKey + ". The upgrade will continue using resource key matching."));
                        }
                    }
                } else {
                    log.warn((Object)("The snmpWwwServiceIndex property should be a positive integer greater than zero but is " + snmpServiceIndex + " instead. The upgrade will continue using the resource key matching."));
                }
            }
        }
        if (newResourceKey != null) {
            ResourceUpgradeReport report = new ResourceUpgradeReport();
            report.setNewResourceKey(newResourceKey);
            return report;
        }
        HashMap<String, Set<VHostSpec>> possibleMatchesPerRK = new HashMap<String, Set<VHostSpec>>();
        for (VHostSpec vhost3 : vhosts) {
            Set<String> legacyResourceKeys = legacyResourceKeyUtil.getLegacyVirtualHostResourceKeys(vhost3);
            for (String legacyRK : legacyResourceKeys) {
                ApacheVirtualHostServiceDiscoveryComponent.addPossibleRKMatch(legacyRK, vhost3, possibleMatchesPerRK);
            }
        }
        for (String legacyRK : legacyResourceKeyUtil.getLegacyMainServerResourceKeys()) {
            ApacheVirtualHostServiceDiscoveryComponent.addPossibleRKMatch(legacyRK, null, possibleMatchesPerRK);
        }
        Set matchingVhosts = (Set)possibleMatchesPerRK.get(resourceKey);
        if (matchingVhosts == null || matchingVhosts.isEmpty()) {
            throw new IllegalArgumentException("Failed to identify the vhost resource with the old-style resource key '" + resourceKey + "' with any of the vhosts in the apache configuration files. This means that the vhost resource is stale and you can safely uninventory it.");
        }
        if (matchingVhosts.size() > 1) {
            String message = "Failed to uniquely identify the vhost from the old-style resource key. The old resource key is '" + resourceKey + "' which could be matched with any of the following possible new-style resource keys: " + matchingVhosts + ". The plugin does not have enough information to successfully upgrade this resource." + " Please take note of any alert definitions or operation schedules that you have defined for this resource and manually uninventory it.";
            throw new IllegalArgumentException(message);
        }
        vhost3 = (VHostSpec)matchingVhosts.iterator().next();
        newResourceKey = vhost3 == null ? "MainServer" : ApacheVirtualHostServiceDiscoveryComponent.createResourceKey(vhost3.serverName, vhost3.hosts);
        ResourceUpgradeReport report = new ResourceUpgradeReport();
        report.setNewResourceKey(newResourceKey);
        return report;
    }

    private void discoverMainServer(ResourceDiscoveryContext<ApacheServerComponent> context, ApacheDirectiveTree runtimeConfig, Set<DiscoveredResourceDetails> discoveredResources) throws Exception {
        ResourceType resourceType = context.getResourceType();
        Configuration mainServerPluginConfig = context.getDefaultPluginConfiguration();
        File configPath = ((ApacheServerComponent)context.getParentResourceComponent()).getServerRoot();
        File logsDir = new File(configPath, LOGS_DIRECTORY_NAME);
        String mainServerUrl = context.getParentResourceContext().getPluginConfiguration().getSimple("url").getStringValue();
        if (mainServerUrl == null || mainServerUrl.trim().isEmpty()) {
            HttpdAddressUtility.Address addr = ((ApacheServerComponent)context.getParentResourceComponent()).getAddressUtility().getMainServerSampleAddress(runtimeConfig, null, 0);
            mainServerUrl = addr.toString();
        }
        PropertySimple mainServerUrlProp = new PropertySimple("url", (Object)mainServerUrl);
        mainServerPluginConfig.put((Property)mainServerUrlProp);
        URI mainServerUri = new URI(mainServerUrl);
        String host = mainServerUri.getHost();
        int port = mainServerUri.getPort();
        if (port == -1) {
            port = 80;
        }
        File rtLogFile = new File(logsDir, host + port + RT_LOG_FILE_NAME_SUFFIX);
        PropertySimple rtLogProp = new PropertySimple("responseTimeLogFile", (Object)rtLogFile.toString());
        mainServerPluginConfig.put((Property)rtLogProp);
        String key = "MainServer";
        DiscoveredResourceDetails mainServer = new DiscoveredResourceDetails(resourceType, key, "Main", null, null, mainServerPluginConfig, null);
        discoveredResources.add(mainServer);
    }

    public static String createResourceKey(String serverName, List<String> hosts) {
        StringBuilder keyBuilder = new StringBuilder();
        if (serverName != null) {
            keyBuilder.append(serverName);
        }
        keyBuilder.append("|");
        keyBuilder.append(hosts.get(0));
        for (int i = 1; i < hosts.size(); ++i) {
            keyBuilder.append(" ").append(hosts.get(i));
        }
        return keyBuilder.toString();
    }

    private static void addPossibleRKMatch(String resourceKey, VHostSpec vhost, Map<String, Set<VHostSpec>> possibleMatches) {
        Set<VHostSpec> matches = possibleMatches.get(resourceKey);
        if (matches == null) {
            matches = new HashSet<VHostSpec>();
            possibleMatches.put(resourceKey, matches);
        }
        matches.add(vhost);
    }
}

