/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl;

import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.pc.PluginContainer;
import org.rhq.test.arquillian.RunDiscovery;
import org.rhq.test.arquillian.spi.PluginContainerOperation;

public class RunDiscoveryExecutor
implements PluginContainerOperation {
    public static RunDiscovery getRunDiscoveryForTest(TestEvent event) {
        RunDiscovery runDiscovery = event.getTestMethod().getAnnotation(RunDiscovery.class);
        if (runDiscovery == null) {
            runDiscovery = (RunDiscovery)event.getTestClass().getAnnotation(RunDiscovery.class);
        }
        return runDiscovery;
    }

    @Override
    public void execute(PluginContainer pluginContainer, TestEvent event) {
        RunDiscovery runDiscovery = RunDiscoveryExecutor.getRunDiscoveryForTest(event);
        if (runDiscovery != null) {
            this.runDiscovery(runDiscovery, pluginContainer);
        }
    }

    private void runDiscovery(RunDiscovery annotation, PluginContainer pluginContainer) {
        InventoryReport serviceScanReport;
        InventoryReport serverScanReport;
        if (annotation.discoverServers() && !(serverScanReport = pluginContainer.getInventoryManager().executeServerScanImmediately()).getErrors().isEmpty()) {
            throw new RuntimeException("Errors occurred during server scan: " + serverScanReport.getErrors());
        }
        if (annotation.discoverServices() && !(serviceScanReport = pluginContainer.getInventoryManager().executeServiceScanImmediately()).getErrors().isEmpty()) {
            throw new RuntimeException("Errors occurred during service scan: " + serviceScanReport.getErrors());
        }
    }
}

