/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl;

import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.test.arquillian.impl.RhqAgentPluginContainer;

public class RhqAgentPluginContainerConfiguration
extends PluginContainerConfiguration
implements ContainerConfiguration {
    private String serverServicesImplementationClassName;
    private boolean nativeSystemInfoEnabled;
    private String additionalPackagesForRootPluginClassLoaderToExclude;
    private boolean clearDataOnShutdown;
    private static final long HUNDRED_YEARS = 3153600000L;

    public RhqAgentPluginContainerConfiguration() {
        this.setAvailabilityScanInitialDelay(3153600000L);
        this.setAvailabilityScanPeriod(3153600000L);
        this.setConfigurationDiscoveryInitialDelay(3153600000L);
        this.setConfigurationDiscoveryPeriod(3153600000L);
        this.setContentDiscoveryInitialDelay(3153600000L);
        this.setContentDiscoveryPeriod(3153600000L);
        this.setDriftDetectionInitialDelay(3153600000L);
        this.setDriftDetectionPeriod(3153600000L);
        this.setEventSenderInitialDelay(3153600000L);
        this.setEventSenderPeriod(3153600000L);
        this.setMeasurementCollectionInitialDelay(3153600000L);
        this.setServerDiscoveryInitialDelay(3153600000L);
        this.setServerDiscoveryPeriod(3153600000L);
        this.setServiceDiscoveryInitialDelay(3153600000L);
        this.setServiceDiscoveryPeriod(3153600000L);
        this.setRootPluginClassLoaderRegex(RhqAgentPluginContainerConfiguration.getDefaultClassLoaderFilter());
        this.setWaitForShutdownServiceTermination(true);
    }

    public String getServerServicesImplementationClassName() {
        return this.serverServicesImplementationClassName;
    }

    public void setServerServicesImplementationClassName(String value) {
        this.serverServicesImplementationClassName = value;
    }

    public boolean isNativeSystemInfoEnabled() {
        return this.nativeSystemInfoEnabled;
    }

    public void setNativeSystemInfoEnabled(boolean nativeSystemInfoEnabled) {
        this.nativeSystemInfoEnabled = nativeSystemInfoEnabled;
    }

    public String getAdditionalPackagesForRootPluginClassLoaderToExclude() {
        return this.additionalPackagesForRootPluginClassLoaderToExclude;
    }

    public void setAdditionalPackagesForRootPluginClassLoaderToExclude(String additionalPackagesForRootPluginClassLoaderToExclude) {
        String[] packagesToExclude;
        this.additionalPackagesForRootPluginClassLoaderToExclude = additionalPackagesForRootPluginClassLoaderToExclude;
        if (this.additionalPackagesForRootPluginClassLoaderToExclude == null || this.additionalPackagesForRootPluginClassLoaderToExclude.isEmpty()) {
            return;
        }
        String regex = this.getRootPluginClassLoaderRegex();
        StringBuilder newRegex = new StringBuilder();
        if (regex != null && !regex.isEmpty()) {
            newRegex.append(regex);
        }
        for (String packageToExclude : packagesToExclude = this.additionalPackagesForRootPluginClassLoaderToExclude.split("\\|")) {
            if (newRegex.length() > 0) {
                newRegex.append('|');
            }
            newRegex.append('(').append(packageToExclude.replaceAll("\\.", "\\\\.")).append("\\..*)");
        }
        this.setRootPluginClassLoaderRegex(newRegex.toString());
    }

    public boolean isClearDataOnShutdown() {
        return this.clearDataOnShutdown;
    }

    public void setClearDataOnShutdown(boolean clearDataOnShutdown) {
        this.clearDataOnShutdown = clearDataOnShutdown;
    }

    public void validate() throws ConfigurationException {
        RhqAgentPluginContainer.init();
        if (this.isNativeSystemInfoEnabled() && !SystemInfoFactory.isNativeSystemInfoAvailable()) {
            throw new ConfigurationException("SIGAR is not available - cannot use native SystemInfo.");
        }
        try {
            String serverServices = this.getServerServicesImplementationClassName();
            if (serverServices != null) {
                Class.forName(serverServices);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to look up the ServerServices implementation class [" + this.getServerServicesImplementationClassName() + "].", (Throwable)e);
        }
    }
}

