/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.arquillian.impl.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;

public class SigarInstaller {
    private static final Log LOG = LogFactory.getLog(SigarInstaller.class);
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private File rootDir;
    private MavenResolvedArtifact sigarDistArtifact;

    public SigarInstaller(File rootDir) {
        this.rootDir = rootDir;
        this.init();
    }

    private void init() {
        Properties pomProperties = new Properties();
        InputStream propertyFileInputStream = this.getClass().getClassLoader().getResourceAsStream("maven-properties.properties");
        try {
            pomProperties.load(propertyFileInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (propertyFileInputStream != null) {
                try {
                    propertyFileInputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        String sigarVersion = pomProperties.getProperty("sigar.version");
        if (sigarVersion == null) {
            throw new RuntimeException("Could not read Sigar version from the properties file");
        }
        this.sigarDistArtifact = (MavenResolvedArtifact)((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomlessResolveStage)Maven.resolver().offline()).loadPomFromFile("pom.xml")).resolve("org.hyperic:sigar-dist:zip:" + sigarVersion)).withoutTransitivity()).asSingleResolvedArtifact();
    }

    public boolean isSigarAvailable() {
        return this.sigarDistArtifact != null;
    }

    public void installSigarNativeLibraries() {
        LOG.debug((Object)("Installing SIGAR native libraries to [" + this.rootDir + "]..."));
        File tempDir = new File(TMP_DIR, UUID.randomUUID().toString());
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        File sigarLibDir = null;
        try {
            File explodedDir = new File(tempDir, "sigar-dist");
            LOG.debug((Object)("Unzipping " + this.sigarDistArtifact + " to " + tempDir + "..."));
            ZipUtil.unzipFile((File)this.sigarDistArtifact.asFile(), (File)explodedDir);
            sigarLibDir = SigarInstaller.findSigarLibDir(explodedDir);
            FileUtil.purge((File)this.rootDir, (boolean)true);
            FileUtil.copyDirectory((File)sigarLibDir, (File)this.rootDir);
            System.setProperty("org.hyperic.sigar.path", this.rootDir.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy SIGAR shared libraries from [" + sigarLibDir + "] to [" + this.rootDir + "].", e);
        }
        finally {
            FileUtil.purge((File)tempDir, (boolean)true);
        }
    }

    private static File findSigarLibDir(File explodedSigarDistZip) {
        File[] foundRootDirs = explodedSigarDistZip.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("hyperic-sigar");
            }
        });
        if (foundRootDirs.length == 0) {
            throw new IllegalStateException("Could not find a directory called \"hyperic-sigar-<VERSION>\" under the Sigar distribution ZIP file.");
        }
        if (foundRootDirs.length > 1) {
            throw new IllegalStateException("There seems to be more than 1 directory starting with \"hyperic-sigar\" under the Sigar distribution ZIP file.");
        }
        File rootDir = foundRootDirs[0];
        File bin = new File(rootDir, "sigar-bin");
        if (!bin.exists()) {
            throw new IllegalStateException("\"sigar-bin\" not found in the Sigar distribution ZIP file.");
        }
        File lib = new File(bin, "lib");
        if (!lib.exists()) {
            throw new IllegalStateException("\"sigar-bin/lib\" not found in the Sigar distribution ZIP file.");
        }
        return lib;
    }
}

