/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.auth;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.auth.IInternodeAuthenticator;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.rhq.cassandra.auth.RhqInternodeAuthenticatorMBean;

public class RhqInternodeAuthenticator
implements IInternodeAuthenticator,
RhqInternodeAuthenticatorMBean {
    private final String MBEAN_NAME = "org.rhq.cassandra.auth:type=" + RhqInternodeAuthenticator.class.getSimpleName();
    private final String CONF_FILE = "rhq-storage-auth.conf";
    private File authConfFile;
    private Set<InetAddress> addresses = new HashSet<InetAddress>();

    public RhqInternodeAuthenticator() {
        try {
            this.authConfFile = new File(this.getClass().getResource("/rhq-storage-auth.conf").toURI());
            if (!this.authConfFile.exists()) {
                throw new RuntimeException(this.authConfFile + " does not exist");
            }
            this.reloadConfiguration();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to load rhq-storage-auth.conf", e);
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nameObj = new ObjectName(this.MBEAN_NAME);
            mbs.registerMBean(this, nameObj);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register MBean " + this.MBEAN_NAME, e);
        }
    }

    public boolean authenticate(InetAddress address, int port) {
        return this.addresses.contains(address);
    }

    @Override
    public void reloadConfiguration() {
        try {
            this.addresses.clear();
            BufferedReader reader = new BufferedReader(new FileReader(this.authConfFile));
            String line = reader.readLine();
            while (line != null) {
                this.addresses.add(InetAddress.getByName(line));
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load addresses from " + this.authConfFile, e);
        }
    }

    public void validateConfiguration() throws ConfigurationException {
    }
}

