/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.ccm.arquillian;

import java.io.File;
import java.util.concurrent.Callable;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.DeploymentEvent;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.test.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.rhq.cassandra.CassandraClusterManager;
import org.rhq.cassandra.ClusterInitService;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.cassandra.DeploymentOptionsFactory;
import org.rhq.cassandra.schema.SchemaManager;

public class CCMSuiteDeploymentExtension
implements LoadableExtension {
    public void register(LoadableExtension.ExtensionBuilder builder) {
        builder.observer(SuiteDeployer.class);
    }

    public static class SuiteDeployer {
        private Class<?> deploymentClass;
        private DeploymentScenario suiteDeploymentScenario;
        private CassandraClusterManager ccm;
        @Inject
        @ClassScoped
        private InstanceProducer<DeploymentScenario> classDeploymentScenario;
        @Inject
        private Event<DeploymentEvent> deploymentEvent;
        @Inject
        private Event<GenerateDeployment> generateDeploymentEvent;
        @Inject
        private Instance<ClassContext> classContext;

        public void startup(@Observes(precedence=-100) ManagerStarted event, ArquillianDescriptor descriptor) {
            this.deploymentClass = this.getDeploymentClass(descriptor);
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SuiteDeployer.this.generateDeploymentEvent.fire((Object)new GenerateDeployment(new TestClass(SuiteDeployer.this.deploymentClass)));
                    SuiteDeployer.this.suiteDeploymentScenario = (DeploymentScenario)SuiteDeployer.this.classDeploymentScenario.get();
                    return null;
                }
            });
        }

        public void initCassandra(@Observes(precedence=-100) BeforeStart event, ArquillianDescriptor descriptor) {
            this.executeInClassScope(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    SchemaManager schemaManager = null;
                    try {
                        ClusterInitService clusterInitService = new ClusterInitService();
                        String[] nodes = null;
                        int[] jmxPorts = null;
                        int cqlPort = -1;
                        if (!Boolean.valueOf(System.getProperty("itest.use-external-storage-node", "false")).booleanValue()) {
                            DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
                            DeploymentOptions options = factory.newDeploymentOptions();
                            File basedir = new File("target");
                            File clusterDir = new File(basedir, "cassandra");
                            options.setUsername("rhqadmin");
                            options.setPassword("1eeb2f255e832171df8592078de921bc");
                            options.setClusterDir(clusterDir.getAbsolutePath());
                            options.setHeapSize("256M");
                            options.setHeapNewSize("64M");
                            options.setStartRpc(Boolean.valueOf(true));
                            SuiteDeployer.this.ccm = new CassandraClusterManager(options);
                            SuiteDeployer.this.ccm.createCluster();
                            nodes = SuiteDeployer.this.ccm.getNodes();
                            jmxPorts = SuiteDeployer.this.ccm.getJmxPorts();
                            cqlPort = SuiteDeployer.this.ccm.getCqlPort();
                            SuiteDeployer.this.ccm.startCluster(false);
                            try {
                                clusterInitService.waitForClusterToStart(nodes, jmxPorts, nodes.length, 2000L, 20, 10);
                                schemaManager = new SchemaManager("rhqadmin", "1eeb2f255e832171df8592078de921bc", nodes, cqlPort);
                            }
                            catch (Exception e) {
                                if (null != SuiteDeployer.this.ccm) {
                                    SuiteDeployer.this.ccm.shutdownCluster();
                                }
                                throw new RuntimeException("Cassandra cluster initialization failed", e);
                            }
                        }
                        try {
                            String nodesString = System.getProperty("rhq.storage.nodes", "127.0.0.1");
                            nodes = nodesString.split(",");
                            String cqlPortString = System.getProperty("rhq.storage.cql-port", "9042");
                            cqlPort = Integer.parseInt(cqlPortString);
                            String jmxPortString = System.getProperty("rhq.storage.jmx-port", "7299");
                            jmxPorts = new int[]{Integer.parseInt(jmxPortString)};
                            schemaManager = new SchemaManager("rhqadmin", "1eeb2f255e832171df8592078de921bc", nodes, cqlPort);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("External Cassandra initialization failed", e);
                        }
                        try {
                            schemaManager.install();
                            clusterInitService.waitForSchemaAgreement(nodes, jmxPorts);
                            schemaManager.updateTopology();
                        }
                        catch (Exception e) {
                            if (null != SuiteDeployer.this.ccm) {
                                SuiteDeployer.this.ccm.shutdownCluster();
                            }
                            throw new RuntimeException("Cassandra schema initialization failed", e);
                        }
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        if (schemaManager != null) {
                            schemaManager.shutdown();
                        }
                    }
                }
            });
        }

        public void deploy(final @Observes AfterStart event, final ContainerRegistry registry) {
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (Deployment d : SuiteDeployer.this.suiteDeploymentScenario.deployments()) {
                        SuiteDeployer.this.deploymentEvent.fire((Object)new DeployDeployment(SuiteDeployer.this.findContainer(registry, event.getDeployableContainer()), d));
                    }
                    return null;
                }
            });
        }

        public void undeploy(final @Observes BeforeStop event, final ContainerRegistry registry) {
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (Deployment d : SuiteDeployer.this.suiteDeploymentScenario.deployments()) {
                        SuiteDeployer.this.deploymentEvent.fire((Object)new UnDeployDeployment(SuiteDeployer.this.findContainer(registry, event.getDeployableContainer()), d));
                    }
                    return null;
                }
            });
        }

        public void shutdownCassandra(@Observes AfterStop event, ArquillianDescriptor descriptor) {
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (null != SuiteDeployer.this.ccm) {
                        SuiteDeployer.this.ccm.shutdownCluster();
                    }
                    return null;
                }
            });
        }

        public void overrideBefore(@Observes EventContext<BeforeClass> event) {
            this.classDeploymentScenario.set((Object)this.suiteDeploymentScenario);
        }

        public void overrideAfter(@Observes EventContext<AfterClass> event) {
        }

        private void executeInClassScope(Callable<Void> call) {
            try {
                ((ClassContext)this.classContext.get()).activate(this.deploymentClass);
                call.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not invoke operation", e);
            }
            finally {
                ((ClassContext)this.classContext.get()).deactivate();
            }
        }

        private Container findContainer(ContainerRegistry registry, DeployableContainer<?> deployable) {
            for (Container container : registry.getContainers()) {
                if (container.getDeployableContainer() != deployable) continue;
                return container;
            }
            return null;
        }

        private Class<?> getDeploymentClass(ArquillianDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException("Descriptor must be specified");
            }
            String className = (String)descriptor.extension("suite").getExtensionProperties().get("deploymentClass");
            if (className == null) {
                throw new IllegalArgumentException("A extension element with property deploymentClass must be specified in arquillian.xml");
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load defined deploymentClass: " + className, e);
            }
        }
    }
}

