/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.ccm.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.rhq.cassandra.CassandraClusterManager;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.cassandra.DeploymentOptionsFactory;

@Mojo(name="shutdown")
public class ShutdownMojo
extends AbstractMojo {
    @Parameter(property="cluster.dir", defaultValue="${project.build.directory}/cassandra")
    private File clusterDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Shutting down cluster in " + this.clusterDir));
        DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
        DeploymentOptions deploymentOptions = factory.newDeploymentOptions();
        deploymentOptions.setClusterDir(this.clusterDir.getAbsolutePath());
        long start = System.currentTimeMillis();
        CassandraClusterManager ccm = new CassandraClusterManager(deploymentOptions);
        ccm.shutdownCluster();
        long end = System.currentTimeMillis();
        this.getLog().info((CharSequence)("Finished cluster shutdown in " + (end - start) + " ms"));
    }
}

