/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.io.File;
import java.util.Set;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.SigarException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jmx.JMXServerComponent;

public class CassandraNodeComponent
extends JMXServerComponent<ResourceComponent<?>>
implements MeasurementFacet,
OperationFacet {
    private Log log = LogFactory.getLog(CassandraNodeComponent.class);

    public AvailabilityType getAvailability() {
        ResourceContext context = this.getResourceContext();
        ProcessInfo processInfo = context.getNativeProcess();
        if (processInfo == null) {
            return AvailabilityType.UNKNOWN;
        }
        ProcessInfo.ProcessInfoSnapshot processInfoSnaphot = processInfo.priorSnaphot();
        if (processInfoSnaphot.isRunning()) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("shutdown")) {
            return this.shutdownNode();
        }
        if (name.equals("start")) {
            return this.startNode();
        }
        if (name.equals("restart")) {
            return this.restartNode();
        }
        return null;
    }

    protected OperationResult shutdownNode() {
        ResourceContext context = this.getResourceContext();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Starting shutdown operation on " + CassandraNodeComponent.class.getName() + " with resource key " + context.getResourceKey()));
        }
        EmsConnection emsConnection = this.getEmsConnection();
        EmsBean storageService = emsConnection.getBean("org.apache.cassandra.db:type=StorageService");
        Class[] emptyParams = new Class[]{};
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Disabling thrift...");
        }
        EmsOperation operation = storageService.getOperation("stopRPCServer", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Disabling gossip...");
        }
        operation = storageService.getOperation("stopGossiping", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initiating drain...");
        }
        operation = storageService.getOperation("drain", emptyParams);
        operation.invoke((Object[])emptyParams);
        ProcessInfo process = context.getNativeProcess();
        long pid = process.getPid();
        try {
            process.kill("KILL");
            return new OperationResult("Successfully shut down Cassandra daemon with pid " + pid);
        }
        catch (SigarException e) {
            this.log.warn((Object)("Failed to shut down Cassandra node with pid " + pid), (Throwable)e);
            OperationResult failure = new OperationResult("Failed to shut down Cassandra node with pid " + pid);
            failure.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)e));
            return failure;
        }
    }

    protected OperationResult startNode() {
        ResourceContext context = this.getResourceContext();
        Configuration pluginConfig = context.getPluginConfiguration();
        String baseDir = pluginConfig.getSimpleValue("baseDir");
        File binDir = new File(baseDir, "bin");
        File startScript = new File(binDir, this.getStartScript());
        ProcessExecution scriptExe = ProcessExecutionUtility.createProcessExecution((File)startScript);
        SystemInfo systemInfo = context.getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(scriptExe);
        if (results.getError() == null) {
            return new OperationResult("Successfully started Cassandra daemon");
        }
        OperationResult failure = new OperationResult("Failed to start Cassandra daemon");
        failure.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)results.getError()));
        return failure;
    }

    protected OperationResult restartNode() {
        OperationResult result = this.shutdownNode();
        if (result.getErrorMessage() == null) {
            result = this.startNode();
        }
        return result;
    }

    private String getStartScript() {
        ResourceContext context = this.getResourceContext();
        SystemInfo systemInfo = context.getSystemInformation();
        if (systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS) {
            return "cassandra.bat";
        }
        return "cassandra";
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        MeasurementScheduleRequest scheduleRequest = null;
        for (MeasurementScheduleRequest r : metrics) {
            if (!r.getName().equals("cluster")) continue;
            scheduleRequest = r;
            break;
        }
        if (scheduleRequest == null) {
            return;
        }
        Cluster cluster = this.getThriftConnection();
        report.addData(new MeasurementDataTrait(scheduleRequest, cluster.describeClusterName()));
    }

    public Cluster getThriftConnection() {
        String thriftPort = this.getResourceContext().getPluginConfiguration().getSimpleValue("thriftPort");
        return HFactory.getOrCreateCluster((String)"rhq", (String)("localhost:" + thriftPort));
    }
}

