/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.util.HashSet;
import java.util.Set;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.cassandra.KeyspaceComponent;

public class ColumnFamilyDiscoveryComponent
implements ResourceDiscoveryComponent<ResourceComponent<?>> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ResourceComponent<?>> context) throws Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        String keyspace = context.getParentResourceContext().getResourceKey();
        KeyspaceComponent parent = (KeyspaceComponent)context.getParentResourceComponent();
        KeyspaceDefinition keyspaceDef = parent.getKeyspaceDefinition();
        for (ColumnFamilyDefinition columnFamilyDef : keyspaceDef.getCfDefs()) {
            String resourceKey = keyspace + "." + columnFamilyDef.getName();
            Configuration pluginConfig = new Configuration();
            pluginConfig.put((Property)new PropertySimple("objectName", (Object)("org.apache.cassandra.db:type=ColumnFamilies,keyspace=" + keyspaceDef.getName() + ",columnfamily=" + columnFamilyDef.getName())));
            pluginConfig.put((Property)new PropertySimple("name", (Object)columnFamilyDef.getName()));
            details.add(new DiscoveredResourceDetails(context.getResourceType(), resourceKey, columnFamilyDef.getName(), null, null, pluginConfig, null));
        }
        return details;
    }
}

