/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.cassandra.ComplexConfigurationResourceComponent;

public class StorageServiceComponent
extends ComplexConfigurationResourceComponent {
    private Log log = LogFactory.getLog(StorageServiceComponent.class);

    public AvailabilityType getAvailability() {
        ResourceContext context = this.getResourceContext();
        try {
            EmsAttribute initializedAttr;
            Boolean initialized;
            EmsBean emsBean = this.loadBean();
            if (emsBean == null) {
                this.log.warn((Object)("Unable to establish JMX connection to " + context.getResourceKey()));
                return AvailabilityType.DOWN;
            }
            AvailabilityType availability = AvailabilityType.UP;
            EmsAttribute thriftEnabledAttr = emsBean.getAttribute("RPCServerRunning");
            Boolean thriftEnabled = (Boolean)thriftEnabledAttr.getValue();
            if (!thriftEnabled.booleanValue()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("Thrift RPC server is disabled for " + context.getResourceKey()));
                }
                availability = AvailabilityType.DOWN;
            }
            if (!(initialized = (Boolean)(initializedAttr = emsBean.getAttribute("Initialized")).getValue()).booleanValue()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)(context.getResourceKey() + " is not initialized"));
                }
                availability = AvailabilityType.DOWN;
            }
            return availability;
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to determine availability for " + context.getResourceKey()), (Throwable)e);
            return AvailabilityType.UNKNOWN;
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("takeSnapshot")) {
            return this.takeSnapshot(parameters);
        }
        if (name.equals("setLog4jLevel")) {
            return this.setLog4jLevel(parameters);
        }
        return super.invokeOperation(name, parameters);
    }

    private OperationResult takeSnapshot(Configuration parameters) {
        EmsBean emsBean = this.getEmsBean();
        EmsOperation operation = emsBean.getOperation("takeSnapshot", new Class[]{String.class, String[].class});
        String snapshotName = parameters.getSimpleValue("snapshotName");
        if (snapshotName == null || snapshotName.trim().isEmpty()) {
            snapshotName = System.currentTimeMillis() + "";
        }
        operation.invoke(new Object[]{snapshotName, new String[0]});
        return new OperationResult();
    }

    private OperationResult setLog4jLevel(Configuration parameters) {
        EmsBean emsBean = this.getEmsBean();
        EmsOperation operation = emsBean.getOperation("setLog4jLevel", new Class[]{String.class, String.class});
        String classQualifier = parameters.getSimpleValue("classQualifier");
        String level = parameters.getSimpleValue("level");
        operation.invoke(new Object[]{classQualifier, level});
        return new OperationResult();
    }
}

