/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.CQLStep;
import org.rhq.cassandra.schema.SchemaManager;
import org.rhq.cassandra.schema.Step;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class UpdateFile
implements Comparable<UpdateFile> {
    private static final String UPDATE_PLAN_ELEMENT = "updatePlan";
    private static final String STEP_ELEMENT = "step";
    private final Log log = LogFactory.getLog(UpdateFile.class);
    private final String file;

    public UpdateFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public List<Step> getOrderedSteps() {
        return this.getStepNodes();
    }

    private List<Step> getStepNodes() {
        InputStream stream = null;
        try {
            stream = SchemaManager.class.getClassLoader().getResourceAsStream(this.file);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            NodeList updateElements = doc.getElementsByTagName(UPDATE_PLAN_ELEMENT);
            if (updateElements == null || updateElements.getLength() != 1) {
                throw new RuntimeException("No <updatePlan> elements found");
            }
            Node rootDocument = updateElements.item(0);
            NodeList updateStepElements = rootDocument.getChildNodes();
            ArrayList<Step> stepList = new ArrayList<Step>();
            for (int index = 0; index < updateStepElements.getLength(); ++index) {
                Step step;
                Node updateStepElement = updateStepElements.item(index);
                if (!STEP_ELEMENT.equals(updateStepElement.getNodeName()) || updateStepElement.getTextContent() == null) continue;
                Node classAttribute = updateStepElement.getAttributes().getNamedItem("class");
                if (classAttribute == null || classAttribute.getNodeValue().equals(CQLStep.class.getSimpleName()) || classAttribute.getNodeValue().toUpperCase().equals("CQL")) {
                    step = new CQLStep(updateStepElement.getTextContent());
                } else {
                    String stepClass = classAttribute.getNodeValue();
                    Class<?> clazz = Class.forName(stepClass);
                    step = (Step)clazz.newInstance();
                }
                stepList.add(step);
            }
            ArrayList<Step> arrayList = stepList;
            return arrayList;
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading the list of steps from " + this.file + " file."), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    this.log.error((Object)("Error closing the stream with the list of steps from " + this.file + " file."), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public int extractVersion() {
        String filename = this.getFile();
        filename = filename.substring(filename.lastIndexOf(47) + 1);
        filename = filename.substring(0, filename.indexOf(46));
        return Integer.parseInt(filename);
    }

    @Override
    public int compareTo(UpdateFile o) {
        return this.getFile().compareTo(o.getFile());
    }
}

