/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.ReadableInstant;
import org.rhq.cassandra.schema.DateRanges;
import org.rhq.cassandra.schema.ReplaceIndex;

public class ReplaceRHQ411Index {
    private static final Log log = LogFactory.getLog(ReplaceRHQ411Index.class);
    private static final int NUM_PARTITIONS = 10;
    private static final int PAGE_SIZE = Integer.parseInt(System.getProperty("rhq.metrics.index.page-size", "2500"));
    private Session session;
    private PreparedStatement find411IndexEntries;
    private PreparedStatement find411IndexEntriesAfterScheduleId;
    private PreparedStatement updateNewIndex;

    public ReplaceRHQ411Index(Session session) {
        this.session = session;
    }

    public void execute(DateRanges dateRanges) {
        this.initPreparedStatements();
        this.updateRawIndex(dateRanges.rawStartTime, dateRanges.rawEndTime);
        this.update1HourIndex(dateRanges.oneHourStartTime, dateRanges.oneHourEndTime);
        this.update6HourIndex(dateRanges.sixHourStartTime, dateRanges.sixHourEndTime);
        this.drop411Index();
    }

    private void initPreparedStatements() {
        this.find411IndexEntries = this.session.prepare("SELECT schedule_id FROM rhq.metrics_index WHERE bucket = ? AND time = ? LIMIT " + PAGE_SIZE);
        this.find411IndexEntriesAfterScheduleId = this.session.prepare("SELECT schedule_id FROM rhq.metrics_index WHERE bucket = ? AND time = ? AND schedule_id > ? LIMIT " + PAGE_SIZE);
        this.updateNewIndex = this.session.prepare("INSERT INTO rhq.metrics_idx (bucket, partition, time, schedule_id) VALUES (?, ?, ?, ?)");
    }

    private void updateRawIndex(DateTime start, DateTime end) {
        log.info((Object)"Updating raw index");
        this.updateIndex("one_hour_metrics", "raw", start, end, Hours.ONE.toStandardDuration());
    }

    private void update1HourIndex(DateTime start, DateTime end) {
        log.info((Object)"Updating one_hour index");
        this.updateIndex("six_hour_metrics", "one_hour", start, end, Hours.SIX.toStandardDuration());
    }

    private void update6HourIndex(DateTime start, DateTime end) {
        log.info((Object)"Updating six_hour index");
        this.updateIndex("twenty_four_hour_metrics", "six_hour", start, end, Days.ONE.toStandardDuration());
    }

    private void updateIndex(String oldBucket, String newBucket, DateTime start, DateTime end, Duration timeSlice) {
        DateTime time = start;
        BoundStatement statement = this.find411IndexEntries.bind(new Object[]{oldBucket, start.toDate()});
        ResultSet resultSet = this.session.execute((Query)statement);
        int count = 0;
        int scheduleId = 0;
        int partition = 0;
        do {
            for (Row row : resultSet) {
                scheduleId = row.getInt(0);
                partition = scheduleId % 10;
                ++count;
                this.session.execute((Query)this.updateNewIndex.bind(new Object[]{newBucket, partition, ReplaceIndex.getUTCTimeSlice(time, timeSlice).toDate(), scheduleId}));
            }
            if (count < PAGE_SIZE) {
                time = ReplaceIndex.plusDSTAware(time, timeSlice);
                statement = this.find411IndexEntries.bind(new Object[]{oldBucket, time.toDate()});
            } else {
                statement = this.find411IndexEntriesAfterScheduleId.bind(new Object[]{oldBucket, time.toDate(), scheduleId});
            }
            count = 0;
            resultSet = this.session.execute((Query)statement);
        } while (!time.isAfter((ReadableInstant)end));
    }

    private void drop411Index() {
        log.info((Object)"Dropping table metrics_index");
        this.session.execute("DROP table rhq.metrics_index");
    }
}

