/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.rhq.cassandra.schema.SessionManager;
import org.rhq.cassandra.schema.TopologyManager;
import org.rhq.cassandra.schema.UpdateFolderFactory;
import org.rhq.cassandra.schema.VersionManager;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;

public class SchemaManager {
    public static final String RELATIONAL_DB_CONNECTION_FACTORY_PROP = "relational_db_connection_factory";
    public static final String DATA_DIR = "data.dir";
    private final String username;
    private final String password;
    private final String[] nodes;
    private final int cqlPort;
    private SessionManager sessionManager;
    private UpdateFolderFactory updateFolderFactory = new UpdateFolderFactory();

    public SchemaManager(String username, String password, String[] nodes, int cqlPort) {
        this.username = username;
        this.password = password;
        this.cqlPort = cqlPort;
        this.nodes = nodes;
        this.sessionManager = new SessionManager();
    }

    public SchemaManager(String username, String password, List<String> nodes, int cqlPort) {
        this(username, password, nodes.toArray(new String[nodes.size()]), cqlPort);
    }

    public void install() throws Exception {
        VersionManager version = new VersionManager(this.username, this.password, this.nodes, this.cqlPort, this.sessionManager, this.updateFolderFactory);
        version.install(new Properties());
    }

    public void install(Properties properties) throws Exception {
        VersionManager version = new VersionManager(this.username, this.password, this.nodes, this.cqlPort, this.sessionManager, this.updateFolderFactory);
        version.install(properties);
    }

    public void checkCompatibility() throws Exception {
        VersionManager version = new VersionManager(this.username, this.password, this.nodes, this.cqlPort, this.sessionManager, this.updateFolderFactory);
        version.checkCompatibility();
    }

    public void drop() throws Exception {
        VersionManager version = new VersionManager(this.username, this.password, this.nodes, this.cqlPort, this.sessionManager, this.updateFolderFactory);
        version.drop();
    }

    public void updateTopology() throws Exception {
        TopologyManager topology = new TopologyManager(this.username, this.password, this.nodes, this.cqlPort, this.sessionManager, this.updateFolderFactory);
        topology.updateTopology();
    }

    public void shutdown() {
        this.sessionManager.shutdownCluster();
    }

    protected String[] getStorageNodes() {
        return this.nodes;
    }

    public Set<String> getStorageNodeAddresses() {
        return this.sessionManager.getNodeAdresses();
    }

    void setUpdateFolderFactory(UpdateFolderFactory updateFolderFactory) {
        this.updateFolderFactory = updateFolderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block11: {
            try {
                Logger root = Logger.getRootLogger();
                if (!root.getAllAppenders().hasMoreElements()) {
                    root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
                }
                Logger migratorLogging = root.getLoggerRepository().getLogger("org.rhq");
                migratorLogging.setLevel(Level.ALL);
                if (args.length < 4) {
                    System.out.println("Usage      : command username password cqlPort nodes...");
                    System.out.println("\n");
                    System.out.println("Commands   : install | drop | topology");
                    return;
                }
                String command = args[0];
                String username = args[1];
                String password = args[2];
                int cqlPort = Integer.parseInt(args[3]);
                String[] hosts = Arrays.copyOfRange(args, 4, args.length);
                SchemaManager schemaManager = new SchemaManager(username, PicketBoxObfuscator.encode((String)password), hosts, cqlPort);
                if ("install".equalsIgnoreCase(command)) {
                    schemaManager.install();
                    break block11;
                }
                if ("drop".equalsIgnoreCase(command)) {
                    schemaManager.drop();
                    break block11;
                }
                if ("topology".equalsIgnoreCase(command)) {
                    schemaManager.updateTopology();
                    break block11;
                }
                throw new IllegalArgumentException(command + " not available.");
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }
}

