/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.SchemaManager;
import org.rhq.cassandra.util.ClusterBuilder;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractManager {
    private static final String UPDATE_PLAN_ELEMENT = "updatePlan";
    private static final String STEP_ELEMENT = "step";
    private static final String SCHEMA_EXISTS_QUERY = "SELECT * FROM system.schema_keyspaces WHERE keyspace_name = 'rhq';";
    private static final String VERSION_COLUMNFAMILY_EXISTS_QUERY = "SELECT * from system.schema_columnfamilies WHERE keyspace_name='rhq' AND columnfamily_name='schema_version';";
    private static final String VERSION_QUERY = "SELECT version FROM rhq.schema_version";
    private static final String REPLICATION_FACTOR_QUERY = "SELECT strategy_options FROM system.schema_keyspaces where keyspace_name='rhq';";
    private final Log log = LogFactory.getLog(AbstractManager.class);
    protected Session session;
    protected final String username;
    protected final String password;
    protected List<StorageNode> nodes = new ArrayList<StorageNode>();

    public AbstractManager(String username, String password, List<StorageNode> nodes) {
        try {
            this.username = username;
            this.password = password;
            this.nodes = nodes;
        }
        catch (NoHostAvailableException e) {
            throw new RuntimeException("Unable create storage node session.", e);
        }
    }

    protected boolean schemaExists() {
        try {
            ResultSet resultSet = this.session.execute(SCHEMA_EXISTS_QUERY);
            if (!resultSet.all().isEmpty()) {
                resultSet = this.session.execute(VERSION_COLUMNFAMILY_EXISTS_QUERY);
                return !resultSet.all().isEmpty();
            }
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected int getSchemaVersion() {
        int maxVersion = 0;
        try {
            ResultSet resultSet = this.session.execute(VERSION_QUERY);
            for (Row row : resultSet.all()) {
                if (maxVersion >= row.getInt(0)) continue;
                maxVersion = row.getInt(0);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        return maxVersion;
    }

    protected void removeAppliedUpdates(List<String> updateFiles, int currentSchemaVersion) {
        int version;
        while (!updateFiles.isEmpty() && (version = this.extractVersionFromUpdateFile(updateFiles.get(0))) <= currentSchemaVersion) {
            updateFiles.remove(0);
        }
    }

    protected int extractVersionFromUpdateFile(String file) {
        file = file.substring(file.lastIndexOf(47) + 1);
        file = file.substring(0, file.indexOf(46));
        return Integer.parseInt(file);
    }

    protected List<String> getSteps(String file) throws Exception {
        ArrayList<String> steps = new ArrayList<String>();
        InputStream stream = null;
        try {
            stream = SchemaManager.class.getClassLoader().getResourceAsStream(file);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Node rootDocument = doc.getElementsByTagName(UPDATE_PLAN_ELEMENT).item(0);
            NodeList updateStepElements = rootDocument.getChildNodes();
            for (int index = 0; index < updateStepElements.getLength(); ++index) {
                Node updateStepElement = updateStepElements.item(index);
                if (!STEP_ELEMENT.equals(updateStepElement.getNodeName()) || updateStepElement.getTextContent() == null) continue;
                steps.add(updateStepElement.getTextContent());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading the list of steps from " + file + " file."), (Throwable)e);
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    this.log.error((Object)("Error closing the stream with the list of steps from " + file + " file."), (Throwable)e);
                    throw e;
                }
            }
        }
        return steps;
    }

    protected List<String> getUpdateFiles(String folder) throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        InputStream stream = null;
        try {
            URL resourceFolderURL = this.getClass().getClassLoader().getResource(folder);
            if (resourceFolderURL.getProtocol().equals("file")) {
                String updateFile;
                stream = this.getClass().getClassLoader().getResourceAsStream(folder);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((updateFile = reader.readLine()) != null) {
                    files.add(folder + updateFile);
                }
            } else if (resourceFolderURL.getProtocol().equals("jar")) {
                URL jarURL = this.getClass().getClassLoader().getResources(folder).nextElement();
                JarURLConnection jarURLCon = (JarURLConnection)jarURL.openConnection();
                JarFile jarFile = jarURLCon.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().getName();
                    if (!entry.startsWith(folder) || entry.equals(folder)) continue;
                    files.add(entry);
                }
            }
            Collections.sort(files, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)"Error reading the list of update files.", (Throwable)e);
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error closing the stream with the list of update files.", (Throwable)e);
                    throw e;
                }
            }
        }
        return files;
    }

    protected void initCluster() {
        this.initCluster(this.username, this.password);
    }

    protected void initCluster(String username, String password) {
        Object[] hostNames = new String[this.nodes.size()];
        for (int i = 0; i < hostNames.length; ++i) {
            hostNames[i] = this.nodes.get(i).getAddress();
        }
        this.log.info((Object)("Initializing session to connect to " + StringUtil.arrayToString((Object[])hostNames)));
        Cluster cluster = new ClusterBuilder().addContactPoints((String[])hostNames).withCredentials(username, password).withPort(this.nodes.get(0).getCqlPort()).withCompression(ProtocolOptions.Compression.NONE).build();
        this.log.info((Object)"Cluster connection configured.");
        this.session = cluster.connect("system");
        this.log.info((Object)"Cluster connected.");
    }

    protected void shutdown() {
        this.log.info((Object)"Shutting down connections");
        this.session.getCluster().shutdown();
    }

    protected int getReplicationFactor() {
        int replicationFactor = 1;
        try {
            String replicationFactorString = "replication_factor\"";
            ResultSet resultSet = this.session.execute(REPLICATION_FACTOR_QUERY);
            Row row = resultSet.one();
            String resultString = row.getString(0);
            resultString = resultString.substring(resultString.indexOf(replicationFactorString) + replicationFactorString.length());
            resultString = resultString.substring(resultString.indexOf(34) + 1);
            resultString = resultString.substring(0, resultString.indexOf(34));
            replicationFactor = Integer.parseInt(resultString);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return replicationFactor;
    }
}

