/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.AbstractManager;
import org.rhq.core.domain.cloud.StorageNode;

public class TopologyManager
extends AbstractManager {
    private final Log log = LogFactory.getLog(TopologyManager.class);
    private static final String TOPOLOGY_BASE_FOLDER = "topology";

    public TopologyManager(String username, String password, List<StorageNode> nodes) {
        super(username, password, nodes);
    }

    public boolean updateTopology() throws Exception {
        boolean result = false;
        this.initCluster();
        if (this.schemaExists()) {
            this.log.info((Object)"Applying topology updates...");
            result = this.updateReplicationFactor(this.nodes.size());
            this.updateGCGrace(this.nodes.size());
        } else {
            this.log.info((Object)"Topology updates cannot be applied because the schema is not installed.");
        }
        this.shutdown();
        return result;
    }

    private boolean updateReplicationFactor(int numberOfNodes) throws Exception {
        this.log.info((Object)("Starting to execute " + (Object)((Object)Task.UpdateReplicationFactor) + " task."));
        int replicationFactor = 1;
        if (numberOfNodes == 2) {
            replicationFactor = 2;
        } else if (numberOfNodes == 3) {
            replicationFactor = 2;
        } else if (numberOfNodes > 3) {
            replicationFactor = 3;
        }
        if (this.getReplicationFactor() == replicationFactor) {
            return false;
        }
        this.log.info((Object)("Applying file " + Task.UpdateReplicationFactor.getFile() + " for " + (Object)((Object)Task.UpdateReplicationFactor) + " task."));
        for (String query : this.getSteps(Task.UpdateReplicationFactor.getFile())) {
            this.executedPreparedStatement(query, replicationFactor);
        }
        this.log.info((Object)("File " + Task.UpdateReplicationFactor.getFile() + " applied for " + (Object)((Object)Task.UpdateReplicationFactor) + " task."));
        this.log.info((Object)("Successfully executed " + (Object)((Object)Task.UpdateReplicationFactor) + " task."));
        return true;
    }

    private boolean updateGCGrace(int numberOfNodes) throws Exception {
        this.log.info((Object)("Starting to execute " + (Object)((Object)Task.UpdateGCGrace) + " task."));
        int gcGraceSeconds = 864000;
        gcGraceSeconds = numberOfNodes == 1 ? 0 : 691200;
        this.log.info((Object)("Applying file " + Task.UpdateGCGrace.getFile() + " for " + (Object)((Object)Task.UpdateGCGrace) + " task."));
        for (String query : this.getSteps(Task.UpdateGCGrace.getFile())) {
            this.executedPreparedStatement(query, gcGraceSeconds);
        }
        this.log.info((Object)("File " + Task.UpdateGCGrace.getFile() + " applied for " + (Object)((Object)Task.UpdateGCGrace) + " task."));
        this.log.info((Object)("Successfully executed " + (Object)((Object)Task.UpdateGCGrace) + " task."));
        return true;
    }

    private void executedPreparedStatement(String query, Object ... values) {
        String formattedQuery = String.format(query, values);
        this.log.info((Object)("Statement: \n" + formattedQuery));
        PreparedStatement preparedStatement = this.session.prepare(formattedQuery);
        BoundStatement boundStatement = preparedStatement.bind(new Object[0]);
        this.session.execute((Query)boundStatement);
    }

    private static enum Task {
        UpdateReplicationFactor("0001.xml"),
        UpdateGCGrace("0002.xml");

        private final String file;

        private Task(String file) {
            this.file = file;
        }

        protected String getFile() {
            return "topology/" + this.file;
        }
    }
}

