/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.UpdateFile;
import org.rhq.cassandra.schema.UpdateFolder;
import org.rhq.cassandra.util.ClusterBuilder;

abstract class AbstractManager {
    private static final String MANAGEMENT_BASE_FOLDER = "management";
    protected static final String DEFAULT_CASSANDRA_USER = "cassandra";
    protected static final String DEFAULT_CASSANDRA_PASSWORD = "-1e4662ac0d7ddef155fd5fac8f894a49";
    private final Log log = LogFactory.getLog(AbstractManager.class);
    private Cluster cluster;
    private Session session;
    private final String username;
    private final String password;
    private final int cqlPort;
    private final String[] nodes;
    private final UpdateFile managementTasks;

    protected AbstractManager(String username, String password, String[] nodes, int cqlPort) {
        try {
            this.username = username;
            this.password = password;
            this.cqlPort = cqlPort;
            this.nodes = nodes;
        }
        catch (NoHostAvailableException e) {
            throw new RuntimeException("Unable create storage node session.", e);
        }
        try {
            UpdateFolder managementFolder = new UpdateFolder(MANAGEMENT_BASE_FOLDER);
            this.managementTasks = managementFolder.getUpdateFiles().get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable create storage node session.", e);
        }
    }

    protected void initClusterSession() {
        this.initClusterSession(this.username, this.password);
    }

    protected void initClusterSession(String username, String password) {
        this.shutdownClusterConnection();
        this.log.info((Object)"Initializing storage node session.");
        this.cluster = new ClusterBuilder().addContactPoints(this.nodes).withCredentialsObfuscated(username, password).withPort(this.getCqlPort()).withCompression(ProtocolOptions.Compression.NONE).build();
        this.log.info((Object)"Cluster connection configured.");
        this.session = this.cluster.connect("system");
        this.log.info((Object)"Cluster connected.");
    }

    protected void shutdownClusterConnection() {
        this.log.info((Object)"Shutting down existing cluster connections");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    protected int getClusterSize() {
        return this.nodes.length;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    protected int getCqlPort() {
        return this.cqlPort;
    }

    protected boolean userExists() {
        try {
            ResultSet resultSet = this.executeManagementQuery(Query.USER_EXISTS, "username", this.username);
            return !resultSet.all().isEmpty();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean schemaExists() {
        try {
            ResultSet resultSet = this.executeManagementQuery(Query.SCHEMA_EXISTS);
            if (!resultSet.all().isEmpty()) {
                resultSet = this.executeManagementQuery(Query.VERSION_COLUMNFAMILY_EXISTS);
                return !resultSet.all().isEmpty();
            }
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected int getInstalledSchemaVersion() {
        int maxVersion = 0;
        try {
            ResultSet resultSet = this.executeManagementQuery(Query.VERSION);
            for (Row row : resultSet.all()) {
                if (maxVersion >= row.getInt(0)) continue;
                maxVersion = row.getInt(0);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        return maxVersion;
    }

    protected int calculateNewReplicationFactor() {
        int replicationFactor = this.getClusterSize() < 3 ? this.getClusterSize() : (this.getClusterSize() < 4 ? 2 : 3);
        return replicationFactor;
    }

    protected int queryReplicationFactor() {
        int replicationFactor = 1;
        try {
            ResultSet resultSet = this.executeManagementQuery(Query.REPLICATION_FACTOR);
            Row row = resultSet.one();
            String replicationFactorString = "replication_factor\"";
            String resultString = row.getString(0);
            resultString = resultString.substring(resultString.indexOf(replicationFactorString) + replicationFactorString.length());
            resultString = resultString.substring(resultString.indexOf(34) + 1);
            resultString = resultString.substring(0, resultString.indexOf(34));
            replicationFactor = Integer.parseInt(resultString);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return replicationFactor;
    }

    protected ResultSet executeManagementQuery(Query query) {
        return this.executeManagementQuery(query, null);
    }

    protected ResultSet executeManagementQuery(Query query, String propertyName, String propertyValue) {
        Properties properties = new Properties();
        properties.put(propertyName, propertyValue);
        return this.executeManagementQuery(query, properties);
    }

    protected ResultSet executeManagementQuery(Query query, Properties properties) {
        String queryString = this.managementTasks.getNamedStep(query.toString(), properties);
        return this.execute(queryString);
    }

    protected List<ResultSet> execute(UpdateFile updateFile) {
        return this.execute(updateFile, null);
    }

    protected List<ResultSet> execute(UpdateFile updateFile, String propertyName, String propertyValue) {
        Properties properties = new Properties();
        properties.put(propertyName, propertyValue);
        return this.execute(updateFile, properties);
    }

    protected List<ResultSet> execute(UpdateFile updateFile, Properties properties) {
        ArrayList<ResultSet> results = new ArrayList<ResultSet>();
        this.log.info((Object)("Applying update file: " + updateFile));
        for (String step : updateFile.getOrderedSteps(properties)) {
            this.log.info((Object)("Statement: \n" + step));
            results.add(this.execute(step));
        }
        this.log.info((Object)("Applied update file: " + updateFile));
        return results;
    }

    protected ResultSet execute(String query) {
        return this.session.execute(query);
    }

    static enum Query {
        USER_EXISTS,
        SCHEMA_EXISTS,
        VERSION_COLUMNFAMILY_EXISTS,
        VERSION,
        REPLICATION_FACTOR,
        INSERT_SCHEMA_VERSION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

