/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import com.datastax.driver.core.exceptions.AuthenticationException;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.schema.AbstractManager;
import org.rhq.cassandra.schema.UpdateFile;
import org.rhq.cassandra.schema.UpdateFolder;
import org.rhq.cassandra.schema.exception.InstalledSchemaTooAdvancedException;
import org.rhq.cassandra.schema.exception.InstalledSchemaTooOldException;
import org.rhq.cassandra.schema.exception.SchemaNotInstalledException;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;

class VersionManager
extends AbstractManager {
    private static final String SCHEMA_BASE_FOLDER = "schema";
    private final Log log = LogFactory.getLog(VersionManager.class);

    public VersionManager(String username, String password, String[] nodes, int cqlPort) throws Exception {
        super(username, password, nodes, cqlPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws Exception {
        this.log.info((Object)"Preparing to install storage schema");
        boolean clusterSessionInitialized = false;
        try {
            this.initClusterSession();
            clusterSessionInitialized = true;
        }
        catch (AuthenticationException e) {
            this.log.debug((Object)"Authentication exception. Will now attempt to create the storage schema.");
            this.log.debug((Object)e);
        }
        finally {
            this.shutdownClusterConnection();
        }
        if (!clusterSessionInitialized) {
            this.create();
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create() throws Exception {
        UpdateFolder updateFolder = new UpdateFolder(Task.Create.getFolder());
        Properties properties = new Properties(System.getProperties());
        properties.put("replication_factor", this.calculateNewReplicationFactor() + "");
        properties.put("cassandra_user_password", UUID.randomUUID() + "");
        properties.put("rhq_admin_username", this.getUsername());
        properties.put("rhq_admin_password", PicketBoxObfuscator.decode((String)this.getPassword()));
        try {
            this.initClusterSession("cassandra", "-1e4662ac0d7ddef155fd5fac8f894a49");
            if (!this.schemaExists()) {
                this.execute(updateFolder.getUpdateFiles().get(0), properties);
            } else {
                this.log.info((Object)"Storage schema already exists.");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.shutdownClusterConnection();
        }
        try {
            this.initClusterSession();
            this.execute(updateFolder.getUpdateFiles().get(1), properties);
        }
        finally {
            this.shutdownClusterConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() throws Exception {
        try {
            this.initClusterSession();
            if (!this.schemaExists()) {
                this.log.error((Object)"Storage schema not installed.");
                throw new RuntimeException("Storage schema not installed propertly, cannot apply schema updates.");
            }
            UpdateFolder updateFolder = new UpdateFolder(Task.Update.getFolder());
            int installedSchemaVersion = this.getInstalledSchemaVersion();
            this.log.info((Object)("Installed storage schema version is " + installedSchemaVersion));
            int requiredSchemaVersion = updateFolder.getLatestVersion();
            this.log.info((Object)("Required storage schema version is " + requiredSchemaVersion));
            if (requiredSchemaVersion == installedSchemaVersion) {
                this.log.info((Object)("Storage schema version is current ( " + installedSchemaVersion + " ). No updates applied."));
            } else {
                if (requiredSchemaVersion < installedSchemaVersion) {
                    this.log.error((Object)("Installed storage cluster schema version: " + installedSchemaVersion + ". Required schema version: " + requiredSchemaVersion + ". Storage cluster schema has been updated beyond the capability of the existing server installation."));
                    throw new InstalledSchemaTooAdvancedException();
                }
                this.log.info((Object)("Storage schema requires udpates. Updating from version " + installedSchemaVersion + " to version " + requiredSchemaVersion + "."));
                updateFolder.removeAppliedUpdates(installedSchemaVersion);
                if (updateFolder.getUpdateFiles().size() == 0) {
                    this.log.info((Object)"Storage schema is current! No updates applied.");
                } else {
                    for (UpdateFile updateFile : updateFolder.getUpdateFiles()) {
                        this.execute(updateFile);
                        Properties versionProperties = new Properties();
                        versionProperties.put("version", updateFile.extractVersion() + "");
                        versionProperties.put("time", System.currentTimeMillis() + "");
                        this.executeManagementQuery(AbstractManager.Query.INSERT_SCHEMA_VERSION, versionProperties);
                        this.log.info((Object)("Storage schema update " + updateFile + " applied."));
                    }
                }
            }
        }
        finally {
            this.shutdownClusterConnection();
        }
    }

    public void drop() throws Exception {
        this.log.info((Object)"Preparing to drop storage schema.");
        UpdateFolder updateFolder = new UpdateFolder(Task.Drop.getFolder());
        Properties properties = new Properties(System.getProperties());
        properties.put("rhq_admin_username", this.getUsername());
        try {
            this.initClusterSession();
            this.execute(updateFolder.getUpdateFiles().get(0), properties);
            this.log.info((Object)"Cassandra user reverted to default configuration.");
        }
        catch (AuthenticationException e) {
            this.log.debug((Object)"Cannot establish connection with the RHQ specific user. Will continue the drop procedure with the Cassandra admin user.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdownClusterConnection();
        }
        try {
            this.initClusterSession("cassandra", "-1e4662ac0d7ddef155fd5fac8f894a49");
            if (this.schemaExists()) {
                this.execute(updateFolder.getUpdateFiles().get(1), properties);
                this.log.info((Object)"Storage schema dropped.");
            } else {
                this.log.info((Object)"Storage schema does not exist. Drop operation not required.");
            }
            if (this.userExists()) {
                this.execute(updateFolder.getUpdateFiles().get(2), properties);
                this.log.info((Object)"RHQ admin user dropped from storage cluster.");
            } else {
                this.log.info((Object)"RHQ admin user does not exist on the storage cluster. Drop operation not required.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdownClusterConnection();
        }
    }

    public void checkCompatibility() throws Exception {
        this.log.info((Object)"Preparing to check storage schema compatibility.");
        try {
            UpdateFolder folder;
            int requiredSchemaVersion;
            this.initClusterSession();
            if (!this.schemaExists()) {
                this.log.error((Object)"Storage cluster schema not installed. Please re-run the server installer to install the storage cluster schema properly.");
                throw new SchemaNotInstalledException();
            }
            int installedSchemaVersion = this.getInstalledSchemaVersion();
            if (installedSchemaVersion < (requiredSchemaVersion = (folder = new UpdateFolder(Task.Update.getFolder())).getLatestVersion())) {
                this.log.error((Object)("Storage cluster schema version:" + installedSchemaVersion + ". Required schema version: " + requiredSchemaVersion + ". Please update storage cluster schema version."));
                throw new InstalledSchemaTooOldException();
            }
            if (installedSchemaVersion > requiredSchemaVersion) {
                this.log.error((Object)("Storage cluster schema version:" + installedSchemaVersion + ". Required schema version: " + requiredSchemaVersion + ". Storage clutser has been updated beyond the capability of the current server installation."));
                throw new InstalledSchemaTooAdvancedException();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdownClusterConnection();
            this.log.info((Object)"Completed storage schema compatibility check.");
        }
    }

    private static enum Task {
        Drop("drop"),
        Create("create"),
        Update("update");

        private final String folder;

        private Task(String folder) {
            this.folder = folder;
        }

        protected String getFolder() {
            return "schema/" + this.folder + "/";
        }
    }
}

