/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.util.stream.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class YumMetadata {
    private static final Log log = LogFactory.getLog(YumMetadata.class);
    public static final String PRIMARY_XML = "primary.xml";
    public static final String REPOMD_XML = "repomd.xml";

    public static boolean generate(StringBuffer sb, Repo repo, List<PackageVersion> pvs, String filename) {
        if (StringUtils.equalsIgnoreCase((String)filename, (String)"primary.xml")) {
            YumMetadata.generatePrimary((StringBuffer)sb, (Repo)repo, pvs);
            return true;
        }
        if (StringUtils.equalsIgnoreCase((String)filename, (String)"repomd.xml")) {
            return YumMetadata.generateRepoMD((StringBuffer)sb, (Repo)repo, pvs);
        }
        return false;
    }

    protected static void generatePrimary(StringBuffer sb, Repo repo, List<PackageVersion> pvs) {
        sb.append("<metadata xmlns=\"http://linux.duke.edu/metadata/common\" ");
        sb.append("packages=\"" + pvs.size() + "\">\n");
        sb.append("xmlns:rpm=\"http://linux.duke.edu/metadata/rpm\" ");
        for (PackageVersion p : pvs) {
            String metadata = YumMetadata.unzip((byte[])p.getMetadata());
            if (StringUtils.isBlank((String)(metadata = YumMetadata.modifyLocation((String)metadata, (String)repo.getName(), (String)p.getFileName())))) {
                log.warn((Object)("No metadata for package : " + p.getDisplayName() + " not adding this to primary.xml"));
                continue;
            }
            sb.append(metadata + "\n");
        }
        sb.append("</metadata>");
    }

    protected static boolean generateRepoMD(StringBuffer sb, Repo repo, List<PackageVersion> pvs) {
        StringBuffer primaryXML = new StringBuffer();
        YumMetadata.generatePrimary((StringBuffer)primaryXML, (Repo)repo, pvs);
        sb.append("<repomd xmlns=\"http://linux.duke.edu/metadata/repo\">");
        try {
            YumMetadata.writeRepoMDEntry((StringBuffer)sb, (String)"primary", (String)YumMetadata.getSHA((StringBuffer)primaryXML), (String)"0");
        }
        catch (NoSuchAlgorithmException e) {
            log.info((Object)e);
            return false;
        }
        catch (IOException e) {
            log.info((Object)e);
            return false;
        }
        sb.append("</repomd>");
        return true;
    }

    protected static String getSHA(StringBuffer primaryXML) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        ByteArrayInputStream bis = new ByteArrayInputStream(primaryXML.toString().getBytes());
        DigestInputStream mdistr = new DigestInputStream(bis, md);
        while (mdistr.read() != -1) {
        }
        mdistr.close();
        return Hex.encodeHexString((byte[])md.digest());
    }

    protected static void writeRepoMDEntry(StringBuffer sb, String type, String sum, String ts) {
        sb.append("\t<data type=\"" + type + "\">\n");
        sb.append("\t<location href=\"repodata/" + type + ".xml\"/>\n");
        sb.append("\t<checksum type=\"sha\">" + sum + "</checksum>\n");
        sb.append("\t<timestamp>" + ts + "</timestamp>\n");
        sb.append("\t</data>\n\n");
    }

    protected static String unzip(byte[] zippedMetadata) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(zippedMetadata);
            ByteArrayOutputStream unzipped = new ByteArrayOutputStream();
            GZIPInputStream gis = new GZIPInputStream(bis);
            StreamUtil.copy((InputStream)gis, (OutputStream)unzipped);
            return unzipped.toString();
        }
        catch (IOException e) {
            log.warn((Object)e);
            return "";
        }
    }

    protected static String modifyLocation(String metadata, String repoName, String filename) {
        String START_STR = "<location ";
        String END_STR = "/>";
        int startIndex = metadata.indexOf("<location ");
        if (startIndex == -1) {
            log.info((Object)"Unable to find <location  in metadata.");
            return metadata;
        }
        int endIndex = metadata.indexOf("/>", startIndex += "<location ".length());
        if (endIndex == -1) {
            log.info((Object)"Unable to find /> in metadata.");
            return metadata;
        }
        String partA = metadata.substring(0, startIndex);
        String partB = metadata.substring(endIndex);
        String href = " href=\"" + filename + "\"";
        return partA + href + partB;
    }
}

