/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cron;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.augeas.util.Glob;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.AugeasConfigurationDiscoveryComponent;
import org.rhq.plugins.cron.CronComponent;

public class CronTabDiscoveryComponent
implements ResourceDiscoveryComponent<CronComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<CronComponent> context) throws InvalidPluginConfigurationException, Exception {
        Configuration cronConfiguration = context.getParentResourceContext().getPluginConfiguration();
        List includes = AugeasConfigurationDiscoveryComponent.getGlobList((PropertySimple)cronConfiguration.getSimple("configurationFilesInclusionPatterns"));
        List excludes = AugeasConfigurationDiscoveryComponent.getGlobList((PropertySimple)cronConfiguration.getSimple("configurationFilesExclusionPatterns"));
        String rootPath = cronConfiguration.getSimpleValue("augeasRootPath", AugeasConfigurationComponent.DEFAULT_AUGEAS_ROOT_PATH);
        List files = Glob.matchAll((File)new File(rootPath), (List)includes);
        Glob.excludeAll((List)files, (List)excludes);
        HashSet<DiscoveredResourceDetails> results = new HashSet<DiscoveredResourceDetails>();
        ResourceType resourceType = context.getResourceType();
        int pathUnderRootStartIdx = rootPath.endsWith(File.separator) ? rootPath.length() - 1 : rootPath.length();
        for (File f : files) {
            String resourceKey = f.getAbsolutePath().substring(pathUnderRootStartIdx);
            Configuration defaultConfiguration = context.getDefaultPluginConfiguration();
            defaultConfiguration.put((Property)AugeasConfigurationDiscoveryComponent.getGlobList((String)"configurationFilesInclusionPatterns", Collections.singletonList(resourceKey)));
            defaultConfiguration.put((Property)new PropertySimple("augeasRootPath", (Object)rootPath));
            DiscoveredResourceDetails result = new DiscoveredResourceDetails(resourceType, resourceKey, resourceKey, null, null, defaultConfiguration, null);
            results.add(result);
        }
        return results;
    }
}

