/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cron;

import java.io.File;
import java.util.List;
import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.helper.AugeasNode;
import org.rhq.plugins.cron.CronComponent;

public class CronTabComponent
extends AugeasConfigurationComponent<CronComponent> {
    public static final String ENVIRONMENT_SETTINGS_PROP = "environmentSettings";
    public static final String ENVIRONMENT_SETTINGS_NODE = ".";
    public static final String VAR_PROP = "var";
    public static final String ENTRIES_PROP = "entries";
    public static final String ENTRIES_NODE = ".";
    public static final String NAME_PROP = "name";
    public static final String VALUE_PROP = "value";
    private File crontabFile;
    private String rootPath;

    public void start(ResourceContext<CronComponent> context) throws InvalidPluginConfigurationException, Exception {
        String augeasRootPath = context.getPluginConfiguration().getSimpleValue("augeasRootPath", AugeasConfigurationComponent.DEFAULT_AUGEAS_ROOT_PATH);
        this.crontabFile = new File(augeasRootPath, context.getResourceKey());
        this.rootPath = AugeasNode.SEPARATOR + "files" + context.getResourceKey();
        super.start(context);
    }

    public AvailabilityType getAvailability() {
        return this.crontabFile.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    protected String getResourceConfigurationRootPath() {
        return this.rootPath;
    }

    protected String getAugeasPathRelativeToParent(PropertyDefinition propDef, AugeasNode parentNode, Augeas augeas) {
        String name = propDef.getName();
        if (ENVIRONMENT_SETTINGS_PROP.equals(name)) {
            return ".";
        }
        if (ENTRIES_PROP.equals(name)) {
            return ".";
        }
        return super.getAugeasPathRelativeToParent(propDef, parentNode, augeas);
    }

    protected Property createPropertyList(PropertyDefinitionList propDefList, Augeas augeas, AugeasNode node) {
        if (ENVIRONMENT_SETTINGS_PROP.equals(propDefList.getName())) {
            List envSettings = augeas.match(node.getPath() + "/*[label() != \"entry\" and label() != \"#comment\"]");
            PropertyList ret = new PropertyList(propDefList.getName());
            for (String path : envSettings) {
                PropertyMap map = new PropertyMap(VAR_PROP);
                ret.add((Property)map);
                String name = new AugeasNode(path).getName();
                String value = augeas.get(path);
                map.put((Property)new PropertySimple(NAME_PROP, (Object)name));
                map.put((Property)new PropertySimple(VALUE_PROP, (Object)value));
            }
            return ret;
        }
        return super.createPropertyList(propDefList, augeas, node);
    }

    protected void setNodeFromPropertyList(PropertyDefinitionList propDefList, PropertyList propList, Augeas augeas, AugeasNode listNode) {
        if (ENVIRONMENT_SETTINGS_PROP.equals(propDefList.getName())) {
            List currentVars = augeas.match(listNode.getPath() + "/*[label() != \"entry\" and label() != \"#comment\"]");
            for (Property p : propList.getList()) {
                PropertyMap map = (PropertyMap)p;
                String name = map.getSimpleValue(NAME_PROP, null);
                String value = map.getSimpleValue(VALUE_PROP, null);
                String path = listNode.getPath() + AugeasNode.SEPARATOR + name;
                augeas.set(path, value);
                currentVars.remove(path);
            }
            for (String path : currentVars) {
                augeas.remove(path);
            }
        } else if (ENTRIES_PROP.equals(propDefList.getName())) {
            super.setNodeFromPropertyList(propDefList, propList, augeas, listNode);
        }
    }

    protected AugeasNode getExistingChildNodeForListMemberPropertyMap(AugeasNode parentNode, PropertyDefinitionList propDefList, PropertyMap propMap) {
        if (ENTRIES_PROP.equals(propDefList.getName())) {
            boolean useIndex;
            int idx = propMap.getParentList().getList().indexOf(propMap);
            int matchesCnt = this.getAugeas().match(parentNode.getPath() + AugeasNode.SEPARATOR + "entry").size();
            boolean bl = useIndex = idx != 0 || matchesCnt > 1;
            if (idx < matchesCnt) {
                return new AugeasNode(parentNode, propMap.getName() + (useIndex ? "[" + (idx + 1) + "]" : ""));
            }
            return null;
        }
        return super.getExistingChildNodeForListMemberPropertyMap(parentNode, propDefList, propMap);
    }
}

