/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator;

import com.datastax.driver.core.Session;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.migrator.workers.AggregateDataMigrator;
import org.rhq.server.metrics.migrator.workers.CallableMigrationWorker;
import org.rhq.server.metrics.migrator.workers.DeleteAllData;
import org.rhq.server.metrics.migrator.workers.RawDataMigrator;

public class DataMigrator {
    private final Log log = LogFactory.getLog(DataMigrator.class);
    public static final double UNDER_ESTIMATION_FACTOR = 0.15;
    public static final int SQL_TIMEOUT = 6000000;
    public static final int MAX_NUMBER_OF_FAILURES = 5;
    private final DataMigratorConfiguration config;
    private long estimation;

    public DataMigrator(EntityManager entityManager, Session session, DatabaseType databaseType) {
        this(entityManager, session, databaseType, false);
    }

    public DataMigrator(EntityManager entityManager, Session session, DatabaseType databaseType, boolean experimentalDataSource) {
        this.config = new DataMigratorConfiguration(entityManager, session, databaseType, experimentalDataSource);
        this.config.setDeleteDataImmediatelyAfterMigration(false);
        this.config.setDeleteAllDataAtEndOfMigration(false);
        this.config.setRunRawDataMigration(true);
        this.config.setRun1HAggregateDataMigration(true);
        this.config.setRun6HAggregateDataMigration(true);
        this.config.setRun1DAggregateDataMigration(true);
    }

    public void runRawDataMigration(boolean value) {
        this.config.setRunRawDataMigration(value);
    }

    public void run1HAggregateDataMigration(boolean value) {
        this.config.setRun1HAggregateDataMigration(value);
    }

    public void run6HAggregateDataMigration(boolean value) {
        this.config.setRun6HAggregateDataMigration(value);
    }

    public void run1DAggregateDataMigration(boolean value) {
        this.config.setRun1DAggregateDataMigration(value);
    }

    public void deleteDataImmediatelyAfterMigration() {
        this.config.setDeleteDataImmediatelyAfterMigration(true);
        this.config.setDeleteAllDataAtEndOfMigration(false);
    }

    public void deleteAllDataAtEndOfMigration() {
        this.config.setDeleteAllDataAtEndOfMigration(true);
        this.config.setDeleteDataImmediatelyAfterMigration(false);
    }

    public void preserveData() {
        this.config.setDeleteAllDataAtEndOfMigration(false);
        this.config.setDeleteDataImmediatelyAfterMigration(false);
    }

    public long estimate() throws Exception {
        this.estimation = 0L;
        if (this.config.isRunRawDataMigration()) {
            this.retryOnFailure(new RawDataMigrator(this.config), Task.Estimate);
        }
        if (this.config.isRun1HAggregateDataMigration()) {
            this.retryOnFailure(new AggregateDataMigrator(MetricsTable.ONE_HOUR, this.config), Task.Estimate);
        }
        if (this.config.isRun6HAggregateDataMigration()) {
            this.retryOnFailure(new AggregateDataMigrator(MetricsTable.SIX_HOUR, this.config), Task.Estimate);
        }
        if (this.config.isRun1DAggregateDataMigration()) {
            this.retryOnFailure(new AggregateDataMigrator(MetricsTable.TWENTY_FOUR_HOUR, this.config), Task.Estimate);
        }
        if (this.config.isDeleteAllDataAtEndOfMigration()) {
            this.retryOnFailure(new DeleteAllData(this.config), Task.Estimate);
        }
        this.estimation = (long)((double)this.estimation + (double)this.estimation * 0.15);
        return this.estimation;
    }

    public void migrateData() throws Exception {
        if (this.config.isRunRawDataMigration()) {
            this.retryOnFailure(new RawDataMigrator(this.config), Task.Migrate);
        }
        if (this.config.isRun1HAggregateDataMigration()) {
            this.retryOnFailure(new AggregateDataMigrator(MetricsTable.ONE_HOUR, this.config), Task.Migrate);
        }
        if (this.config.isRun6HAggregateDataMigration()) {
            this.retryOnFailure(new AggregateDataMigrator(MetricsTable.SIX_HOUR, this.config), Task.Migrate);
        }
        if (this.config.isRun1DAggregateDataMigration()) {
            this.retryOnFailure(new AggregateDataMigrator(MetricsTable.TWENTY_FOUR_HOUR, this.config), Task.Migrate);
        }
        if (this.config.isDeleteAllDataAtEndOfMigration()) {
            this.retryOnFailure(new DeleteAllData(this.config), Task.Migrate);
        }
    }

    public void deleteOldData() throws Exception {
        if (this.config.isDeleteAllDataAtEndOfMigration()) {
            this.retryOnFailure(new DeleteAllData(this.config), Task.Migrate);
        }
    }

    private Thread retryOnFailure(final CallableMigrationWorker migrator, final Task task) throws Exception {
        RunnableWithException runnable = new RunnableWithException(){
            private Exception exception;

            @Override
            public void run() {
                Exception caughtException = null;
                DataMigrator.this.log.info(migrator.getClass());
                for (int numberOfFailures = 0; numberOfFailures < 5; ++numberOfFailures) {
                    try {
                        if (task == Task.Estimate) {
                            DataMigrator.this.estimation += migrator.estimate();
                        } else {
                            migrator.migrate();
                        }
                        return;
                    }
                    catch (Exception e) {
                        DataMigrator.this.log.error((Object)("Migrator " + migrator.getClass() + " failed. Retrying!"), (Throwable)e);
                        caughtException = e;
                        continue;
                    }
                }
                this.exception = caughtException;
            }

            @Override
            public Exception getException() {
                return this.exception;
            }
        };
        Thread localThread = new Thread(runnable);
        localThread.start();
        localThread.join();
        if (runnable.getException() != null) {
            throw runnable.getException();
        }
        return localThread;
    }

    public class DataMigratorConfiguration {
        private final EntityManager entityManager;
        private final Session session;
        private final DatabaseType databaseType;
        private final boolean experimentalDataSource;
        private boolean deleteDataImmediatelyAfterMigration;
        private boolean deleteAllDataAtEndOfMigration;
        private boolean runRawDataMigration;
        private boolean run1HAggregateDataMigration;
        private boolean run6HAggregateDataMigration;
        private boolean run1DAggregateDataMigration;

        public DataMigratorConfiguration(EntityManager entityManager, Session session, DatabaseType databaseType, boolean experimentalDataSource) {
            this.entityManager = entityManager;
            this.session = session;
            this.databaseType = databaseType;
            this.experimentalDataSource = experimentalDataSource;
        }

        public boolean isDeleteDataImmediatelyAfterMigration() {
            return this.deleteDataImmediatelyAfterMigration;
        }

        private void setDeleteDataImmediatelyAfterMigration(boolean deleteDataImmediatelyAfterMigration) {
            this.deleteDataImmediatelyAfterMigration = deleteDataImmediatelyAfterMigration;
        }

        public boolean isDeleteAllDataAtEndOfMigration() {
            return this.deleteAllDataAtEndOfMigration;
        }

        private void setDeleteAllDataAtEndOfMigration(boolean deleteAllDataAtEndOfMigration) {
            this.deleteAllDataAtEndOfMigration = deleteAllDataAtEndOfMigration;
        }

        public boolean isRunRawDataMigration() {
            return this.runRawDataMigration;
        }

        private void setRunRawDataMigration(boolean runRawDataMigration) {
            this.runRawDataMigration = runRawDataMigration;
        }

        public boolean isRun1HAggregateDataMigration() {
            return this.run1HAggregateDataMigration;
        }

        private void setRun1HAggregateDataMigration(boolean run1hAggregateDataMigration) {
            this.run1HAggregateDataMigration = run1hAggregateDataMigration;
        }

        public boolean isRun6HAggregateDataMigration() {
            return this.run6HAggregateDataMigration;
        }

        private void setRun6HAggregateDataMigration(boolean run6hAggregateDataMigration) {
            this.run6HAggregateDataMigration = run6hAggregateDataMigration;
        }

        public boolean isRun1DAggregateDataMigration() {
            return this.run1DAggregateDataMigration;
        }

        private void setRun1DAggregateDataMigration(boolean run1dAggregateDataMigration) {
            this.run1DAggregateDataMigration = run1dAggregateDataMigration;
        }

        public EntityManager getEntityManager() {
            return this.entityManager;
        }

        public Session getSession() {
            return this.session;
        }

        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        public boolean isExperimentalDataSource() {
            return this.experimentalDataSource;
        }
    }

    private static interface RunnableWithException
    extends Runnable {
        public Exception getException();
    }

    public static enum Task {
        Migrate,
        Estimate;

    }

    public static enum DatabaseType {
        Postgres,
        Oracle;

    }
}

