/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.hibernate.ejb.Ejb3Configuration;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;
import org.rhq.server.metrics.migrator.DataMigrator;
import org.rhq.server.metrics.migrator.workers.AggregateDataMigrator;
import org.rhq.server.metrics.migrator.workers.DeleteAllData;
import org.rhq.server.metrics.migrator.workers.MetricsIndexUpdateAccumulator;
import org.rhq.server.metrics.migrator.workers.RawDataMigrator;

public class DataMigratorRunner {
    private static final int DEFAULT_CASSANDRA_PORT = 9142;
    private final Log log = LogFactory.getLog(DataMigratorRunner.class);
    private final Option cassandraUserOption;
    private final Option cassandraPasswordOption;
    private final Option cassandraHostsOption;
    private final Option cassandraPortOption;
    private final Option sqlUserOption;
    private final Option sqlPasswordOption;
    private final Option sqlConnectionUrlOption;
    private final Option sqlHostOption;
    private final Option sqlPortOption;
    private Option sqlDBOption;
    private final Option sqlServerTypeOption;
    private final Option sqlPostgresServerOption;
    private final Option sqlOracleServerOption;
    private final Option disableRawOption;
    private final Option disable1HOption;
    private final Option disable6HOption;
    private final Option disable1DOption;
    private final Option deleteDataOption;
    private final Option estimateOnlyOption;
    private final Option deleteOnlyOption;
    private final Option experimentalExportOption;
    private final Option helpOption;
    private final Option debugLogOption;
    private final Option configFileOption;
    private final Option serverPropertiesFileOption;
    private Map<Object, Object> configuration;
    private Options options;

    public DataMigratorRunner() {
        OptionBuilder.withLongOpt((String)"cassandra-user");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"Cassandra user (default: rhqadmin)");
        this.cassandraUserOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"cassandra-password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Cassandra password (default: rhqadmin)");
        OptionBuilder.withType(String.class);
        this.cassandraPasswordOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"cassandra-hosts");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"Cassandra hosts, format host_ip_1,host_ip_2,... (default: 127.0.0.1");
        this.cassandraHostsOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"cassandra-port");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription((String)"Cassandra native binary protocol port (default: 9142)");
        this.cassandraPortOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-user");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"SQL server user (default: rhqadmin)");
        this.sqlUserOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-password");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"SQL server password (default: rhqadmin)");
        this.sqlPasswordOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-connection-url");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"SQL connection url. Not used by default. If specified will override host, port and db SQL options.");
        this.sqlConnectionUrlOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-host");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"SQL server host address (default: localhost)");
        this.sqlHostOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-port");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"SQL server port (default: 5432)");
        this.sqlPortOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-db");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"SQL database (default: rhq)");
        this.sqlDBOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-server-type");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.withDescription((String)"SQL server type, only postgres and oracle are supported (default: postgres)");
        this.sqlServerTypeOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-server-postgres");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Postgres SQL server.");
        this.sqlPostgresServerOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"sql-server-oracle");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Oracle SQL server.");
        this.sqlOracleServerOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"disable-raw-migration");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Disable raw table migration (default: false)");
        this.disableRawOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"disable-1h-migration");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Disable 1 hour aggregates table migration (default: false)");
        this.disable1HOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"disable-6h-migration");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Disable 6 hours aggregates table migration (default: false)");
        this.disable6HOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"disable-1d-migration");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Disable 24 hours aggregates table migration (default: false)");
        this.disable1DOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"delete-data");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Delete SQL data at the end of migration (default: false)");
        this.deleteDataOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"estimate-only");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Only estimate how long the migration will take (default: false)");
        this.estimateOnlyOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"delete-only");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Only delete data from the old SQL server, no migration will be performed (default: false)");
        this.deleteOnlyOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"experimental-export");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription((String)"Enable experimental bulk export for Postgres, option ignored for Oracle migration (default: false)");
        this.experimentalExportOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"help");
        this.helpOption = OptionBuilder.create((String)"h");
        OptionBuilder.withLongOpt((String)"debugLog");
        OptionBuilder.withDescription((String)"Enable debug level logs for the communication with Cassandra and SQL Server (default: false)");
        this.debugLogOption = OptionBuilder.create((String)"X");
        OptionBuilder.withLongOpt((String)"config-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Configuration file. All the command line options can be set in a typical properties file. Command line arguments take precedence over default, RHQ server properties,  and configuration file options.");
        this.configFileOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"rhq-server-properties-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"RHQ Server configuration file (rhq-server.properties). The RHQ server properties will be used for SQL server configuration. Command line arguments take precedence over default, RHQ server properties, and configuration file options.");
        this.serverPropertiesFileOption = OptionBuilder.create();
        this.configuration = new HashMap<Object, Object>();
    }

    public static void main(String[] args) throws Exception {
        DataMigratorRunner.initLogging();
        try {
            DataMigratorRunner runner = new DataMigratorRunner();
            runner.configure(args);
            runner.run();
        }
        catch (HelpRequestedException h) {
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void initLogging() {
        Logger root = Logger.getRootLogger();
        if (!root.getAllAppenders().hasMoreElements()) {
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
            DataMigratorRunner.setLogLevel(Level.ERROR);
        }
    }

    private static void setLogLevel(Level level) {
        Class[] clazzes;
        Logger root = Logger.getRootLogger();
        root.setLevel(level);
        Logger cassandraLogging = root.getLoggerRepository().getLogger("log4j.logger.org.apache.cassandra.cql.jdbc");
        cassandraLogging.setLevel(level);
        Logger cassandraDriverLogging = root.getLoggerRepository().getLogger("com.datastax.driver");
        cassandraDriverLogging.setLevel(level);
        Logger hibernateLogging = root.getLoggerRepository().getLogger("org.hibernate");
        hibernateLogging.setLevel(Level.ERROR);
        Logger migratorLogging = root.getLoggerRepository().getLogger("org.rhq");
        if (Level.DEBUG.equals((Object)level)) {
            migratorLogging.setLevel(Level.ALL);
        } else {
            migratorLogging.setLevel(level);
        }
        for (Class clazz : clazzes = new Class[]{DataMigratorRunner.class, DataMigrator.class, RawDataMigrator.class, DeleteAllData.class, AggregateDataMigrator.class, MetricsIndexUpdateAccumulator.class}) {
            migratorLogging = Logger.getLogger((Class)clazz);
            if (Level.DEBUG.equals((Object)level)) {
                migratorLogging.setLevel(Level.ALL);
                continue;
            }
            migratorLogging.setLevel(level);
        }
    }

    private void configure(String[] args) throws Exception {
        CommandLine commandLine;
        this.options = new Options();
        this.options.addOption(this.cassandraUserOption);
        this.options.addOption(this.cassandraPasswordOption);
        this.options.addOption(this.cassandraHostsOption);
        this.options.addOption(this.cassandraPortOption);
        this.options.addOption(this.sqlUserOption);
        this.options.addOption(this.sqlPasswordOption);
        this.options.addOption(this.sqlHostOption);
        this.options.addOption(this.sqlPortOption);
        this.options.addOption(this.sqlDBOption);
        this.options.addOption(this.sqlServerTypeOption);
        this.options.addOption(this.sqlPostgresServerOption);
        this.options.addOption(this.sqlOracleServerOption);
        this.options.addOption(this.sqlConnectionUrlOption);
        this.options.addOption(this.disableRawOption);
        this.options.addOption(this.disable1HOption);
        this.options.addOption(this.disable6HOption);
        this.options.addOption(this.disable1DOption);
        this.options.addOption(this.deleteDataOption);
        this.options.addOption(this.estimateOnlyOption);
        this.options.addOption(this.deleteOnlyOption);
        this.options.addOption(this.experimentalExportOption);
        this.options.addOption(this.helpOption);
        this.options.addOption(this.debugLogOption);
        this.options.addOption(this.configFileOption);
        this.options.addOption(this.serverPropertiesFileOption);
        try {
            PosixParser parser = new PosixParser();
            commandLine = parser.parse(this.options, args);
        }
        catch (Exception e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp("DataMigrationRunner", this.options);
            throw new Exception("Error parsing command line arguments");
        }
        if (commandLine.hasOption(this.helpOption.getLongOpt()) || commandLine.hasOption(this.helpOption.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("DataMigrationRunner", this.options);
            throw new HelpRequestedException();
        }
        if (commandLine.hasOption(this.debugLogOption.getLongOpt()) || commandLine.hasOption(this.debugLogOption.getOpt())) {
            DataMigratorRunner.setLogLevel(Level.DEBUG);
        }
        this.loadDefaultConfiguration();
        if (commandLine.hasOption(this.serverPropertiesFileOption.getLongOpt())) {
            this.log.debug((Object)("Server configuration file option enabled. Loading server configuration from file: " + this.serverPropertiesFileOption.getLongOpt()));
            this.loadConfigurationFromServerPropertiesFile(commandLine.getOptionValue(this.serverPropertiesFileOption.getLongOpt()));
            this.log.debug((Object)"Server configuration file from system properties will not be loaded even if set because of the manual override.");
        } else if (System.getProperty("rhq.server.properties-file") != null) {
            this.log.debug((Object)("Server configuration file system property detected. Loading the file: " + System.getProperty("rhq.server.properties-file")));
            this.loadConfigurationFromServerPropertiesFile(System.getProperty("rhq.server.properties-file"));
            this.log.debug((Object)"Server configuration file loaded based on system properties options.");
        }
        if (commandLine.hasOption(this.configFileOption.getLongOpt())) {
            this.loadConfigFile(commandLine.getOptionValue(this.configFileOption.getLongOpt()));
        }
        this.parseCassandraOptions(commandLine);
        this.parseSQLOptions(commandLine);
        this.parseMigrationOptions(commandLine);
        if (commandLine.hasOption(this.debugLogOption.getLongOpt()) || commandLine.hasOption(this.debugLogOption.getOpt())) {
            this.printOptions();
        }
    }

    private void loadDefaultConfiguration() throws Exception {
        this.configuration.put(this.cassandraUserOption, "rhqadmin");
        this.configuration.put(this.cassandraPasswordOption, "rhqadmin");
        this.configuration.put(this.cassandraHostsOption, new String[]{InetAddress.getLocalHost().getHostAddress()});
        this.configuration.put(this.cassandraPortOption, 9142);
        this.configuration.put(this.sqlUserOption, "rhqadmin");
        this.configuration.put(this.sqlPasswordOption, "rhqadmin");
        this.configuration.put(this.sqlHostOption, "localhost");
        this.configuration.put(this.sqlPortOption, "5432");
        this.configuration.put(this.sqlDBOption, "rhq");
        this.configuration.put(this.sqlServerTypeOption, (Object)DataMigrator.DatabaseType.Postgres);
        this.configuration.put(this.disableRawOption, false);
        this.configuration.put(this.disable1HOption, false);
        this.configuration.put(this.disable6HOption, false);
        this.configuration.put(this.disable1DOption, false);
        this.configuration.put(this.estimateOnlyOption, false);
        this.configuration.put(this.deleteDataOption, false);
        this.configuration.put(this.deleteOnlyOption, false);
        this.configuration.put(this.experimentalExportOption, false);
    }

    private void loadConfigurationFromServerPropertiesFile(String file) throws Exception {
        File configFile = new File(file);
        if (!configFile.exists()) {
            throw new FileNotFoundException("RHQ server properties file not found! File: " + file);
        }
        Properties serverProperties = new Properties();
        FileInputStream stream = new FileInputStream(configFile);
        serverProperties.load(stream);
        stream.close();
        String dbType = serverProperties.getProperty("rhq.server.database.type-mapping");
        DataMigrator.DatabaseType databaseType = DataMigrator.DatabaseType.Postgres;
        if (dbType != null && dbType.toLowerCase().contains("oracle")) {
            databaseType = DataMigrator.DatabaseType.Oracle;
        }
        this.configuration.put(this.sqlServerTypeOption, (Object)databaseType);
        this.configuration.put(this.sqlUserOption, serverProperties.getProperty("rhq.server.database.user-name"));
        String dbPasswordProperty = serverProperties.getProperty("rhq.server.database.password");
        this.configuration.put(this.sqlPasswordOption, PicketBoxObfuscator.decode((String)dbPasswordProperty));
        this.configuration.put(this.sqlConnectionUrlOption, serverProperties.getProperty("rhq.server.database.connection-url"));
        this.configuration.put(this.cassandraUserOption, serverProperties.getProperty("rhq.storage.username"));
        String cassandraPasswordProperty = serverProperties.getProperty("rhq.storage.password");
        this.configuration.put(this.cassandraPasswordOption, PicketBoxObfuscator.decode((String)cassandraPasswordProperty));
        if (serverProperties.getProperty("rhq.storage.nodes") != null && !serverProperties.getProperty("rhq.storage.nodes").trim().isEmpty()) {
            String[] storageNodes = serverProperties.getProperty("rhq.storage.nodes").split(",");
            this.configuration.put(this.cassandraHostsOption, storageNodes);
        }
        if (serverProperties.getProperty("rhq.storage.cql-port") != null && !serverProperties.getProperty("rhq.storage.cql-port").trim().isEmpty()) {
            Integer cassandraPort = Integer.parseInt(serverProperties.getProperty("rhq.storage.cql-port"));
            this.configuration.put(this.cassandraPortOption, cassandraPort);
        }
    }

    private void loadConfigFile(String file) {
        try {
            File configFile = new File(file);
            if (!configFile.exists()) {
                throw new FileNotFoundException("Configuration file not found!");
            }
            Properties configProperties = new Properties();
            FileInputStream stream = new FileInputStream(configFile);
            configProperties.load(stream);
            stream.close();
            for (Object optionObject : this.options.getOptions()) {
                Option option = (Option)optionObject;
                Object optionValue = configProperties.get(option.getLongOpt());
                if (optionValue == null) continue;
                this.log.debug((Object)("Configuration option loaded: " + option.getLongOpt() + " (" + option.getType() + ") -> " + optionValue));
                if (option.equals((Object)this.cassandraHostsOption)) {
                    String[] cassandraHosts = this.parseCassandraHosts(optionValue.toString());
                    this.configuration.put(option, cassandraHosts);
                    continue;
                }
                if (option.equals((Object)this.sqlServerTypeOption)) {
                    if ("oracle".equals(optionValue)) {
                        this.configuration.put(option, (Object)DataMigrator.DatabaseType.Oracle);
                        continue;
                    }
                    this.configuration.put(option, (Object)DataMigrator.DatabaseType.Postgres);
                    continue;
                }
                if (option.equals((Object)this.sqlPostgresServerOption)) {
                    boolean value = this.tryParseBoolean(optionValue.toString(), true);
                    if (!value) continue;
                    this.configuration.put(this.sqlServerTypeOption, (Object)DataMigrator.DatabaseType.Postgres);
                    continue;
                }
                if (option.equals((Object)this.sqlOracleServerOption)) {
                    boolean value = this.tryParseBoolean(optionValue.toString(), true);
                    if (!value) continue;
                    this.configuration.put(this.sqlServerTypeOption, (Object)DataMigrator.DatabaseType.Oracle);
                    continue;
                }
                if (option.getType().equals(Boolean.class)) {
                    this.configuration.put(option, this.tryParseBoolean(optionValue.toString(), true));
                    continue;
                }
                if (option.getType().equals(Integer.class)) {
                    this.configuration.put(option, this.tryParseInteger(optionValue.toString(), 0));
                    continue;
                }
                this.configuration.put(option, optionValue.toString());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to load or process the configuration file.", (Throwable)e);
            System.exit(1);
        }
    }

    private void parseCassandraOptions(CommandLine commandLine) throws Exception {
        if (commandLine.hasOption(this.cassandraUserOption.getLongOpt())) {
            this.configuration.put(this.cassandraUserOption, commandLine.getOptionValue(this.cassandraUserOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.cassandraPasswordOption.getLongOpt())) {
            this.configuration.put(this.cassandraPasswordOption, commandLine.getOptionValue(this.cassandraPasswordOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.cassandraHostsOption.getLongOpt())) {
            String[] cassandraHosts = this.parseCassandraHosts(commandLine.getOptionValue(this.cassandraHostsOption.getLongOpt()));
            this.configuration.put(this.cassandraHostsOption, cassandraHosts);
        }
        if (commandLine.hasOption(this.cassandraPortOption.getLongOpt())) {
            Integer cassandraPort = this.tryParseInteger(commandLine.getOptionValue(this.cassandraPortOption.getLongOpt()), 9142);
            this.configuration.put(this.cassandraPortOption, cassandraPort);
        }
    }

    private void parseSQLOptions(CommandLine commandLine) throws NoHostAvailableException {
        if (commandLine.hasOption(this.sqlUserOption.getLongOpt())) {
            this.configuration.put(this.sqlUserOption, commandLine.getOptionValue(this.sqlUserOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.sqlPasswordOption.getLongOpt())) {
            this.configuration.put(this.sqlPasswordOption, commandLine.getOptionValue(this.sqlPasswordOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.sqlHostOption.getLongOpt())) {
            this.configuration.put(this.sqlHostOption, commandLine.getOptionValue(this.sqlHostOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.sqlPortOption.getLongOpt())) {
            this.configuration.put(this.sqlPortOption, commandLine.getOptionValue(this.sqlPortOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.sqlDBOption.getLongOpt())) {
            this.configuration.put(this.sqlDBOption, commandLine.getOptionValue(this.sqlDBOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.sqlConnectionUrlOption.getLongOpt())) {
            this.configuration.put(this.sqlConnectionUrlOption, commandLine.getOptionValue(this.sqlConnectionUrlOption.getLongOpt()));
        }
        if (commandLine.hasOption(this.sqlServerTypeOption.getLongOpt())) {
            if ("oracle".equals(commandLine.getOptionValue(this.sqlServerTypeOption.getLongOpt()))) {
                this.configuration.put(this.sqlServerTypeOption, (Object)DataMigrator.DatabaseType.Oracle);
            } else {
                this.configuration.put(this.sqlServerTypeOption, (Object)DataMigrator.DatabaseType.Postgres);
            }
        } else if (commandLine.hasOption(this.sqlPostgresServerOption.getLongOpt())) {
            this.configuration.put(this.sqlServerTypeOption, (Object)DataMigrator.DatabaseType.Postgres);
        } else if (commandLine.hasOption(this.sqlOracleServerOption.getLongOpt())) {
            this.configuration.put(this.sqlServerTypeOption, (Object)DataMigrator.DatabaseType.Oracle);
        }
    }

    private void parseMigrationOptions(CommandLine commandLine) {
        boolean value;
        if (commandLine.hasOption(this.disableRawOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.disableRawOption.getLongOpt()), true);
            this.configuration.put(this.disableRawOption, value);
        }
        if (commandLine.hasOption(this.disable1HOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.disable1HOption.getLongOpt()), true);
            this.configuration.put(this.disable1HOption, value);
        }
        if (commandLine.hasOption(this.disable6HOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.disable6HOption.getLongOpt()), true);
            this.configuration.put(this.disable6HOption, value);
        }
        if (commandLine.hasOption(this.disable1DOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.disable1DOption.getLongOpt()), true);
            this.configuration.put(this.disable1DOption, value);
        }
        if (commandLine.hasOption(this.deleteDataOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.deleteDataOption.getLongOpt()), true);
            this.configuration.put(this.deleteDataOption, value);
        }
        if (commandLine.hasOption(this.deleteOnlyOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.deleteOnlyOption.getLongOpt()), true);
            this.configuration.put(this.deleteOnlyOption, value);
        }
        if (commandLine.hasOption(this.estimateOnlyOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.estimateOnlyOption.getLongOpt()), true);
            this.configuration.put(this.estimateOnlyOption, value);
        }
        if (commandLine.hasOption(this.experimentalExportOption.getLongOpt())) {
            value = this.tryParseBoolean(commandLine.getOptionValue(this.experimentalExportOption.getLongOpt()), true);
            this.configuration.put(this.experimentalExportOption, value);
        }
    }

    private void run() throws Exception {
        this.log.debug((Object)"Creating Entity Manager");
        EntityManagerFactory entityManagerFactory = this.createEntityManagerFactory();
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        this.log.debug((Object)"Done creating Entity Manager");
        this.log.debug((Object)"Creating Cassandra session");
        Session cassandraSession = this.createCassandraSession();
        this.log.debug((Object)"Done creating Cassandra session");
        DataMigrator.DatabaseType databaseType = DataMigrator.DatabaseType.Postgres;
        if (this.configuration.get(this.sqlServerTypeOption) != null) {
            databaseType = (DataMigrator.DatabaseType)((Object)this.configuration.get(this.sqlServerTypeOption));
        }
        DataMigrator migrator = new DataMigrator(entityManager, cassandraSession, databaseType, this.tryParseBoolean(this.configuration.get(this.experimentalExportOption), false));
        if (!((Boolean)this.configuration.get(this.deleteOnlyOption)).booleanValue()) {
            if (((Boolean)this.configuration.get(this.deleteDataOption)).booleanValue()) {
                migrator.deleteAllDataAtEndOfMigration();
            } else {
                migrator.preserveData();
            }
            migrator.runRawDataMigration((Boolean)this.configuration.get(this.disableRawOption) == false);
            migrator.run1HAggregateDataMigration((Boolean)this.configuration.get(this.disable1HOption) == false);
            migrator.run6HAggregateDataMigration((Boolean)this.configuration.get(this.disable6HOption) == false);
            migrator.run1DAggregateDataMigration((Boolean)this.configuration.get(this.disable1DOption) == false);
            System.out.println("Estimation process - starting\n");
            long estimate = migrator.estimate();
            System.out.println("The migration process will take approximately: " + TimeUnit.MILLISECONDS.toMinutes(estimate) + " minutes (or " + estimate + " milliseconds)\n");
            System.out.println("Estimation process - ended\n\n");
            if (!((Boolean)this.configuration.get(this.estimateOnlyOption)).booleanValue()) {
                System.out.println("Migration process - starting\n");
                long startTime = System.currentTimeMillis();
                migrator.migrateData();
                long duration = System.currentTimeMillis() - startTime;
                System.out.println("The migration process took: " + TimeUnit.MILLISECONDS.toMinutes(duration) + " minutes (or " + duration + " milliseconds)\n");
                System.out.println("Migration process - ended\n");
            }
        } else {
            migrator.deleteAllDataAtEndOfMigration();
            migrator.runRawDataMigration(false);
            migrator.run1HAggregateDataMigration(false);
            migrator.run6HAggregateDataMigration(false);
            migrator.run1DAggregateDataMigration(false);
            System.out.println("Estimation process - starting\n");
            long estimate = migrator.estimate();
            System.out.println("The deletion of old data will take approximately: " + TimeUnit.MILLISECONDS.toMinutes(estimate) + " minutes (or " + estimate + " milliseconds)\n");
            System.out.println("Estimation process - ended\n\n");
            if (!((Boolean)this.configuration.get(this.estimateOnlyOption)).booleanValue()) {
                migrator.runRawDataMigration(true);
                migrator.run1HAggregateDataMigration(true);
                migrator.run6HAggregateDataMigration(true);
                migrator.run1DAggregateDataMigration(true);
                System.out.println("Old data deletion process - starting\n");
                long startTime = System.currentTimeMillis();
                migrator.deleteOldData();
                long duration = System.currentTimeMillis() - startTime;
                System.out.println("The deletion process took: " + TimeUnit.MILLISECONDS.toMinutes(duration) + " minutes (or " + duration + " milliseconds)\n");
                System.out.println("Old data deletion process - ended\n");
            }
        }
        this.closeCassandraSession(cassandraSession);
        this.closeEntityManagerFactory(entityManagerFactory);
    }

    private void closeCassandraSession(Session session) {
        session.getCluster().shutdown();
    }

    private void closeEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        if (entityManagerFactory != null) {
            entityManagerFactory.close();
        }
    }

    private Session createCassandraSession() throws Exception {
        Cluster cluster = Cluster.builder().addContactPoints((String[])this.configuration.get(this.cassandraHostsOption)).withPort(((Integer)this.configuration.get(this.cassandraPortOption)).intValue()).withCompression(ProtocolOptions.Compression.NONE).withoutMetrics().withCredentials((String)this.configuration.get(this.cassandraUserOption), (String)this.configuration.get(this.cassandraPasswordOption)).build();
        try {
            return cluster.connect("rhq");
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to connect to the storage cluster.", (Throwable)e);
            cluster.shutdown();
            throw e;
        }
    }

    private EntityManagerFactory createEntityManagerFactory() throws Exception {
        String driverClassName;
        Properties properties = new Properties();
        properties.put("javax.persistence.provider", "org.hibernate.ejb.HibernatePersistence");
        properties.put("hibernate.connection.username", (String)this.configuration.get(this.sqlUserOption));
        properties.put("hibernate.connection.password", (String)this.configuration.get(this.sqlPasswordOption));
        properties.put("javax.persistence.query.timeout", (Object)6000000);
        properties.put("hibernate.c3p0.timeout", (Object)6000000);
        if (DataMigrator.DatabaseType.Oracle.equals(this.configuration.get(this.sqlServerTypeOption))) {
            driverClassName = "oracle.jdbc.driver.OracleDriver";
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                this.log.debug((Object)e);
                throw new Exception("Oracle SQL Driver class could not be loaded. Missing class: " + driverClassName);
            }
            properties.put("hibernate.dialect", "org.hibernate.dialect.Oracle10gDialect");
            properties.put("hibernate.driver_class", driverClassName);
            if (this.configuration.get(this.sqlConnectionUrlOption) != null) {
                properties.put("hibernate.connection.url", (String)this.configuration.get(this.sqlConnectionUrlOption));
            } else {
                properties.put("hibernate.connection.url", "jdbc:oracle:thin:@" + (String)this.configuration.get(this.sqlHostOption) + ":" + (String)this.configuration.get(this.sqlPortOption) + ":" + (String)this.configuration.get(this.sqlDBOption));
                properties.put("hibernate.default_schema", (String)this.configuration.get(this.sqlDBOption));
            }
            properties.put("hibernate.connection.oracle.jdbc.ReadTimeout", (Object)6000000);
        } else {
            driverClassName = "org.postgresql.Driver";
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                this.log.debug((Object)e);
                throw new Exception("Postgres SQL Driver class could not be loaded. Missing class: " + driverClassName);
            }
            properties.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
            properties.put("hibernate.driver_class", driverClassName);
            if (this.configuration.get(this.sqlConnectionUrlOption) != null) {
                properties.put("hibernate.connection.url", (String)this.configuration.get(this.sqlConnectionUrlOption));
            } else {
                properties.put("hibernate.connection.url", "jdbc:postgresql://" + (String)this.configuration.get(this.sqlHostOption) + ":" + (String)this.configuration.get(this.sqlPortOption) + "/" + (String)this.configuration.get(this.sqlDBOption));
            }
        }
        this.log.debug((Object)"Creating entity manager with the following configuration:");
        this.log.debug((Object)properties);
        Ejb3Configuration configuration = new Ejb3Configuration();
        configuration.setProperties(properties);
        EntityManagerFactory factory = configuration.buildEntityManagerFactory();
        return factory;
    }

    private void printOptions() {
        this.log.debug((Object)"Running migration with the following optons: ");
        for (Map.Entry<Object, Object> configOption : this.configuration.entrySet()) {
            Option option = (Option)configOption.getKey();
            if (option.getLongOpt() != null && !option.getLongOpt().contains("pass")) {
                if (!(configOption.getValue() instanceof Object[])) {
                    this.log.debug((Object)("  " + option.getLongOpt() + " : " + configOption.getValue()));
                    continue;
                }
                StringBuffer arrayProperty = new StringBuffer();
                arrayProperty.append("  ").append(option.getLongOpt()).append(" : [");
                boolean first = true;
                for (Object value : (Object[])configOption.getValue()) {
                    if (!first) {
                        arrayProperty.append(", ");
                    }
                    arrayProperty.append(value);
                    first = false;
                }
                arrayProperty.append("]");
                this.log.debug((Object)arrayProperty.toString());
                continue;
            }
            this.log.debug((Object)("  " + option.getLongOpt() + " : <obscured value>"));
        }
    }

    private String[] parseCassandraHosts(String stringValue) {
        String[] seeds = stringValue.split(",");
        return seeds;
    }

    private boolean tryParseBoolean(Object value, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private Integer tryParseInteger(Object value, int defaultValue) {
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private class HelpRequestedException
    extends Exception {
        public HelpRequestedException() {
            super("Help Requested");
        }
    }
}

