/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.workers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.rhq.server.metrics.migrator.DataMigrator;
import org.rhq.server.metrics.migrator.datasources.ExistingDataSource;
import org.rhq.server.metrics.migrator.datasources.ExistingPostgresDataBulkExportSource;
import org.rhq.server.metrics.migrator.datasources.ScrollableDataSource;

public abstract class AbstractMigrationWorker {
    private final Log log = LogFactory.getLog(AbstractMigrationWorker.class);

    protected static String[] getRawDataTables() {
        int tableCount = 15;
        String tablePrefix = "RHQ_MEAS_DATA_NUM_R";
        String[] tables = new String[tableCount];
        for (int i = 0; i < tableCount; ++i) {
            tables[i] = i < 10 ? tablePrefix + "0" + i : tablePrefix + i;
        }
        return tables;
    }

    protected ExistingDataSource getExistingDataSource(String query, DataMigrator.Task task, DataMigrator.DataMigratorConfiguration config) {
        if (DataMigrator.Task.Migrate.equals((Object)task)) {
            if (DataMigrator.DatabaseType.Oracle.equals((Object)config.getDatabaseType())) {
                return new ScrollableDataSource(config.getEntityManager(), config.getDatabaseType(), query);
            }
            if (!config.isExperimentalDataSource()) {
                return new ScrollableDataSource(config.getEntityManager(), config.getDatabaseType(), query);
            }
            return new ExistingPostgresDataBulkExportSource(config.getEntityManager(), query);
        }
        if (DataMigrator.Task.Estimate.equals((Object)task)) {
            int limit = 150000;
            if (DataMigrator.DatabaseType.Oracle.equals((Object)config.getDatabaseType())) {
                return new ScrollableDataSource(config.getEntityManager(), config.getDatabaseType(), query, limit);
            }
            if (!config.isExperimentalDataSource()) {
                return new ScrollableDataSource(config.getEntityManager(), config.getDatabaseType(), query, limit);
            }
            return new ExistingPostgresDataBulkExportSource(config.getEntityManager(), query, limit);
        }
        return new ScrollableDataSource(config.getEntityManager(), config.getDatabaseType(), query);
    }

    protected void prepareSQLSession(StatelessSession session, DataMigrator.DataMigratorConfiguration config) {
        if (DataMigrator.DatabaseType.Postgres.equals((Object)config.getDatabaseType())) {
            this.log.debug((Object)"Preparing SQL connection with timeout: 6000000");
            SQLQuery query = session.createSQLQuery("SET LOCAL statement_timeout = 6000000");
            query.setReadOnly(true);
            query.executeUpdate();
        }
    }

    protected StatelessSession getSQLSession(DataMigrator.DataMigratorConfiguration config) {
        StatelessSession session = ((Session)config.getEntityManager().getDelegate()).getSessionFactory().openStatelessSession();
        this.prepareSQLSession(session, config);
        return session;
    }

    protected void closeSQLSession(StatelessSession session) {
        try {
            if (session != null) {
                session.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

