/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.workers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.StatelessSession;
import org.rhq.server.metrics.migrator.DataMigrator;
import org.rhq.server.metrics.migrator.workers.AbstractMigrationWorker;
import org.rhq.server.metrics.migrator.workers.CallableMigrationWorker;
import org.rhq.server.metrics.migrator.workers.MigrationQuery;

public class DeleteAllData
extends AbstractMigrationWorker
implements CallableMigrationWorker {
    private final Log log = LogFactory.getLog(DeleteAllData.class);
    private final DataMigrator.DataMigratorConfiguration config;

    public DeleteAllData(DataMigrator.DataMigratorConfiguration config) {
        this.config = config;
    }

    @Override
    public void migrate() {
        SQLQuery nativeQuery;
        StatelessSession session = this.getSQLSession(this.config);
        if (this.config.isRun1HAggregateDataMigration()) {
            session.getTransaction().begin();
            nativeQuery = session.createSQLQuery(MigrationQuery.DELETE_1H_DATA.toString());
            nativeQuery.executeUpdate();
            session.getTransaction().commit();
            this.log.info((Object)"- RHQ_MEASUREMENT_DATA_NUM_1H - Cleaned -");
        }
        if (this.config.isRun6HAggregateDataMigration()) {
            session.getTransaction().begin();
            nativeQuery = session.createSQLQuery(MigrationQuery.DELETE_6H_DATA.toString());
            nativeQuery.executeUpdate();
            session.getTransaction().commit();
            this.log.info((Object)"- RHQ_MEASUREMENT_DATA_NUM_6H - Cleaned -");
        }
        if (this.config.isRun1DAggregateDataMigration()) {
            session.getTransaction().begin();
            nativeQuery = session.createSQLQuery(MigrationQuery.DELETE_1D_DATA.toString());
            nativeQuery.executeUpdate();
            session.getTransaction().commit();
            this.log.info((Object)"- RHQ_MEASUREMENT_DATA_NUM_1D - Cleaned -");
        }
        if (this.config.isRunRawDataMigration()) {
            for (String table : DeleteAllData.getRawDataTables()) {
                session.getTransaction().begin();
                String deleteAllData = String.format(MigrationQuery.DELETE_RAW_ALL_DATA.toString(), table);
                nativeQuery = session.createSQLQuery(deleteAllData);
                nativeQuery.executeUpdate();
                session.getTransaction().commit();
                this.log.info((Object)("- " + table + " - Cleaned -"));
            }
        }
        this.closeSQLSession(session);
    }

    @Override
    public long estimate() throws Exception {
        return 300000L;
    }
}

