/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.workers;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSetFuture;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.StatelessSession;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.migrator.DataMigrator;
import org.rhq.server.metrics.migrator.workers.AbstractMigrationWorker;
import org.rhq.server.metrics.migrator.workers.MigrationQuery;
import org.rhq.server.metrics.migrator.workers.MigrationTable;

public class MetricsIndexMigrator
extends AbstractMigrationWorker {
    private static final int MAX_SIZE = 3000;
    private final Log log = LogFactory.getLog(MetricsIndexMigrator.class);
    private final DateTimeService dateTimeService = new DateTimeService();
    private final MetricsConfiguration metricsConfiguration = new MetricsConfiguration();
    private final Map<Integer, Set<Long>> accumulator = new HashMap<Integer, Set<Long>>();
    private final MigrationTable table;
    private final DataMigrator.DataMigratorConfiguration migratorConfiguration;
    private final long timeLimit;
    private final PreparedStatement updateMetricsIndex;
    private final Duration sliceDuration;
    private final boolean validAccumulatorTable;
    private int currentCount = 0;

    public MetricsIndexMigrator(MigrationTable table, DataMigrator.DataMigratorConfiguration config) {
        this.table = table;
        this.migratorConfiguration = config;
        if (MigrationTable.RAW.equals((Object)table) || MigrationTable.ONE_HOUR.equals((Object)table) || MigrationTable.SIX_HOUR.equals((Object)table)) {
            this.sliceDuration = this.getTimeSliceDuration(table);
            this.timeLimit = this.getLastAggregationTime(table) - this.sliceDuration.getMillis();
            this.updateMetricsIndex = config.getSession().prepare("INSERT INTO " + MetricsTable.INDEX + " " + "(bucket, partition, time, schedule_id) " + "VALUES (?, ?, ?, ?) ");
            this.validAccumulatorTable = true;
        } else {
            this.timeLimit = Integer.MAX_VALUE;
            this.updateMetricsIndex = null;
            this.sliceDuration = null;
            this.validAccumulatorTable = false;
        }
    }

    public void add(int scheduleId, long timestamp) throws Exception {
        if (this.validAccumulatorTable && this.timeLimit <= timestamp) {
            long alignedTimeSlice = this.dateTimeService.getTimeSlice(timestamp, this.sliceDuration).getMillis();
            if (this.accumulator.containsKey(scheduleId)) {
                Set<Long> timestamps = this.accumulator.get(scheduleId);
                if (!timestamps.contains(alignedTimeSlice)) {
                    timestamps.add(alignedTimeSlice);
                    ++this.currentCount;
                }
            } else {
                HashSet<Long> timestamps = new HashSet<Long>();
                timestamps.add(timestamp);
                this.accumulator.put(scheduleId, timestamps);
                ++this.currentCount;
            }
        }
        if (this.currentCount > 3000) {
            this.drain();
        }
    }

    public void drain() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Draining metrics index accumulator with " + this.currentCount + " entries"));
        }
        ArrayList<ResultSetFuture> resultSetFutures = new ArrayList<ResultSetFuture>();
        for (Map.Entry<Integer, Set<Long>> entry : this.accumulator.entrySet()) {
            for (Long timestamp : entry.getValue()) {
                Integer scheduleId = entry.getKey();
                BoundStatement statement = this.updateMetricsIndex.bind(new Object[]{this.table.getAggregationBucket().toString(), scheduleId % this.metricsConfiguration.getIndexPartitions(), new Date(timestamp), scheduleId});
                resultSetFutures.add(this.migratorConfiguration.getSession().executeAsync((Query)statement));
            }
        }
        for (ResultSetFuture future : resultSetFutures) {
            future.get();
        }
        this.accumulator.clear();
        this.currentCount = 0;
    }

    private long getLastAggregationTime(MigrationTable migratedTable) {
        SQLQuery query;
        Object result;
        StatelessSession session = this.getSQLSession(this.migratorConfiguration);
        long aggregationSlice = Integer.MAX_VALUE;
        Duration duration = null;
        String queryString = null;
        if (MigrationTable.RAW.equals((Object)migratedTable)) {
            duration = this.metricsConfiguration.getRawTimeSliceDuration();
            queryString = MigrationQuery.MAX_TIMESTAMP_1H_DATA.toString();
        } else if (MigrationTable.ONE_HOUR.equals((Object)migratedTable)) {
            duration = this.metricsConfiguration.getOneHourTimeSliceDuration();
            queryString = MigrationQuery.MAX_TIMESTAMP_6H_DATA.toString();
        } else if (MigrationTable.SIX_HOUR.equals((Object)migratedTable)) {
            duration = this.metricsConfiguration.getSixHourTimeSliceDuration();
            queryString = MigrationQuery.MAX_TIMESTAMP_1D_DATA.toString();
        }
        if (duration != null && queryString != null && (result = (query = session.createSQLQuery(queryString)).uniqueResult()) != null) {
            String queryResult = query.uniqueResult().toString();
            Long timestamp = Long.parseLong(queryResult);
            aggregationSlice = this.dateTimeService.getTimeSlice(new DateTime((Object)timestamp), duration).getMillis();
        }
        this.closeSQLSession(session);
        return aggregationSlice;
    }

    public Duration getTimeSliceDuration(MigrationTable table) {
        if (MigrationTable.RAW.equals((Object)table)) {
            return this.metricsConfiguration.getRawTimeSliceDuration();
        }
        if (MigrationTable.ONE_HOUR.equals((Object)table)) {
            return this.metricsConfiguration.getOneHourTimeSliceDuration();
        }
        if (MigrationTable.SIX_HOUR.equals((Object)table)) {
            return this.metricsConfiguration.getSixHourTimeSliceDuration();
        }
        throw new IllegalArgumentException("Time slice duration for " + table.getTableName() + " table is not supported");
    }
}

